/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.encoding;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.encoding.FourFlagsIntEncoder;
import org.apache.lucene.util.encoding.IntDecoder;
import org.apache.lucene.util.encoding.NOnesIntDecoder;

public class NOnesIntEncoder
extends FourFlagsIntEncoder {
    private final IntsRef internalBuffer;
    private final int n;

    public NOnesIntEncoder(int n) {
        this.n = n;
        this.internalBuffer = new IntsRef(n);
    }

    @Override
    public void encode(IntsRef values, BytesRef buf) {
        this.internalBuffer.length = 0;
        if (values.length > this.internalBuffer.ints.length) {
            this.internalBuffer.grow(values.length);
        }
        int onesCounter = 0;
        int upto = values.offset + values.length;
        for (int i = values.offset; i < upto; ++i) {
            int value = values.ints[i];
            if (value == 1) {
                if (++onesCounter != this.n) continue;
                this.internalBuffer.ints[this.internalBuffer.length++] = 2;
                onesCounter = 0;
                continue;
            }
            while (onesCounter > 0) {
                --onesCounter;
                this.internalBuffer.ints[this.internalBuffer.length++] = 1;
            }
            this.internalBuffer.ints[this.internalBuffer.length++] = value + 1;
        }
        while (onesCounter > 0) {
            --onesCounter;
            this.internalBuffer.ints[this.internalBuffer.length++] = 1;
        }
        super.encode(this.internalBuffer, buf);
    }

    @Override
    public IntDecoder createMatchingDecoder() {
        return new NOnesIntDecoder(this.n);
    }

    @Override
    public String toString() {
        return "NOnes(" + this.n + ") (" + super.toString() + ")";
    }
}

