/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.encoding;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.encoding.IntDecoder;
import org.apache.lucene.util.encoding.IntEncoder;
import org.apache.lucene.util.encoding.SimpleIntDecoder;

public final class SimpleIntEncoder
extends IntEncoder {
    @Override
    public void encode(IntsRef values, BytesRef buf) {
        buf.length = 0;
        buf.offset = 0;
        int bytesNeeded = values.length * 4;
        if (buf.bytes.length < bytesNeeded) {
            buf.grow(bytesNeeded);
        }
        int upto = values.offset + values.length;
        for (int i = values.offset; i < upto; ++i) {
            int value = values.ints[i];
            buf.bytes[buf.length++] = (byte)(value >>> 24);
            buf.bytes[buf.length++] = (byte)(value >> 16 & 0xFF);
            buf.bytes[buf.length++] = (byte)(value >> 8 & 0xFF);
            buf.bytes[buf.length++] = (byte)(value & 0xFF);
        }
    }

    @Override
    public IntDecoder createMatchingDecoder() {
        return new SimpleIntDecoder();
    }

    public String toString() {
        return "Simple";
    }
}

