/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import org.apache.lucene.facet.search.Aggregator;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.ScoringAggregator;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;

public class SumScoreFacetRequest
extends FacetRequest {
    public SumScoreFacetRequest(CategoryPath path, int num) {
        super(path, num);
    }

    @Override
    public Aggregator createAggregator(boolean useComplements, FacetArrays arrays, TaxonomyReader taxonomy) {
        assert (!useComplements) : "complements are not supported by this FacetRequest";
        return new ScoringAggregator(arrays.getFloatArray());
    }

    @Override
    public double getValueOf(FacetArrays arrays, int ordinal) {
        return arrays.getFloatArray()[ordinal];
    }

    @Override
    public FacetRequest.FacetArraysSource getFacetArraysSource() {
        return FacetRequest.FacetArraysSource.FLOAT;
    }
}

