/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.associations;

import java.io.IOException;
import org.apache.lucene.facet.params.CategoryListParams;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetsAggregator;
import org.apache.lucene.facet.search.FacetsCollector;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.BytesRef;

public class SumFloatAssociationFacetsAggregator
implements FacetsAggregator {
    private final BytesRef bytes = new BytesRef(32);

    @Override
    public void aggregate(FacetsCollector.MatchingDocs matchingDocs, CategoryListParams clp, FacetArrays facetArrays) throws IOException {
        BinaryDocValues dv = matchingDocs.context.reader().getBinaryDocValues(clp.field + "$assoc_float$");
        if (dv == null) {
            return;
        }
        int length = matchingDocs.bits.length();
        float[] values = facetArrays.getFloatArray();
        int doc = 0;
        while (doc < length && (doc = matchingDocs.bits.nextSetBit(doc)) != -1) {
            dv.get(doc, this.bytes);
            if (this.bytes.length == 0) continue;
            int bytesUpto = this.bytes.offset + this.bytes.length;
            int pos = this.bytes.offset;
            while (pos < bytesUpto) {
                int ordinal = (this.bytes.bytes[pos++] & 0xFF) << 24 | (this.bytes.bytes[pos++] & 0xFF) << 16 | (this.bytes.bytes[pos++] & 0xFF) << 8 | this.bytes.bytes[pos++] & 0xFF;
                int value = (this.bytes.bytes[pos++] & 0xFF) << 24 | (this.bytes.bytes[pos++] & 0xFF) << 16 | (this.bytes.bytes[pos++] & 0xFF) << 8 | this.bytes.bytes[pos++] & 0xFF;
                int n = ordinal;
                values[n] = values[n] + Float.intBitsToFloat(value);
            }
            ++doc;
        }
    }

    @Override
    public boolean requiresDocScores() {
        return false;
    }

    private float rollupValues(int ordinal, int[] children, int[] siblings, float[] scores) {
        float Value = 0.0f;
        while (ordinal != -1) {
            float childValue = scores[ordinal];
            scores[ordinal] = childValue += this.rollupValues(children[ordinal], children, siblings, scores);
            Value += childValue;
            ordinal = siblings[ordinal];
        }
        return Value;
    }

    @Override
    public void rollupValues(FacetRequest fr, int ordinal, int[] children, int[] siblings, FacetArrays facetArrays) {
        float[] values = facetArrays.getFloatArray();
        int n = ordinal;
        values[n] = values[n] + this.rollupValues(children[ordinal], children, siblings, values);
    }
}

