/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.codecs.facet42;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.packed.PackedInts;

public class Facet42DocValuesConsumer
extends DocValuesConsumer {
    final IndexOutput out;
    final int maxDoc;
    final float acceptableOverheadRatio;

    public Facet42DocValuesConsumer(SegmentWriteState state) throws IOException {
        this(state, 0.2f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Facet42DocValuesConsumer(SegmentWriteState state, float acceptableOverheadRatio) throws IOException {
        this.acceptableOverheadRatio = acceptableOverheadRatio;
        boolean success = false;
        try {
            String fileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"fdv");
            this.out = state.directory.createOutput(fileName, state.context);
            CodecUtil.writeHeader((DataOutput)this.out, (String)"FacetsDocValues", (int)0);
            this.maxDoc = state.segmentInfo.getDocCount();
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this});
            throw throwable;
        }
    }

    public void addNumericField(FieldInfo field, Iterable<Number> values) throws IOException {
        throw new UnsupportedOperationException("FacetsDocValues can only handle binary fields");
    }

    public void addBinaryField(FieldInfo field, Iterable<BytesRef> values) throws IOException {
        this.out.writeVInt(field.number);
        long totBytes = 0L;
        for (BytesRef v : values) {
            totBytes += (long)v.length;
        }
        if (totBytes > Integer.MAX_VALUE) {
            throw new IllegalStateException("too many facets in one segment: Facet42DocValues cannot handle more than 2 GB facet data per segment");
        }
        this.out.writeVInt((int)totBytes);
        for (BytesRef v : values) {
            this.out.writeBytes(v.bytes, v.offset, v.length);
        }
        PackedInts.Writer w = PackedInts.getWriter((DataOutput)this.out, (int)(this.maxDoc + 1), (int)PackedInts.bitsRequired((long)(totBytes + 1L)), (float)this.acceptableOverheadRatio);
        int address = 0;
        for (BytesRef v : values) {
            w.add((long)address);
            address += v.length;
        }
        w.add((long)address);
        w.finish();
    }

    public void addSortedField(FieldInfo field, Iterable<BytesRef> values, Iterable<Number> docToOrd) throws IOException {
        throw new UnsupportedOperationException("FacetsDocValues can only handle binary fields");
    }

    public void addSortedSetField(FieldInfo field, Iterable<BytesRef> values, Iterable<Number> docToOrdCount, Iterable<Number> ords) throws IOException {
        throw new UnsupportedOperationException("FacetsDocValues can only handle binary fields");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        block5: {
            block4: {
                boolean success = false;
                try {
                    this.out.writeVInt(-1);
                    success = true;
                    if (!success) break block4;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{this.out});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.out});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{this.out});
                break block5;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.out});
        }
    }
}

