/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.collections;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.lucene.facet.collections.FloatIterator;
import org.apache.lucene.facet.collections.IntIterator;

public class ObjectToFloatMap<K> {
    private static int defaultCapacity = 16;
    int[] baseHash;
    private int capacity = 16;
    private int firstEmpty;
    private int hashFactor;
    Object[] keys;
    int[] next;
    private int prev;
    private int size;
    float[] values;

    public ObjectToFloatMap() {
        this(defaultCapacity);
    }

    public ObjectToFloatMap(int capacity) {
        while (this.capacity < capacity) {
            this.capacity <<= 1;
        }
        int arrayLength = this.capacity + 1;
        this.values = new float[arrayLength];
        this.keys = new Object[arrayLength];
        this.next = new int[arrayLength];
        int baseHashSize = this.capacity << 1;
        this.baseHash = new int[baseHashSize];
        this.hashFactor = baseHashSize - 1;
        this.size = 0;
        this.clear();
    }

    private void prvt_put(K key, float e) {
        int hashIndex = this.calcBaseHashIndex(key);
        int objectIndex = this.firstEmpty;
        this.firstEmpty = this.next[this.firstEmpty];
        this.values[objectIndex] = e;
        this.keys[objectIndex] = key;
        this.next[objectIndex] = this.baseHash[hashIndex];
        this.baseHash[hashIndex] = objectIndex;
        ++this.size;
    }

    protected int calcBaseHashIndex(K key) {
        return key.hashCode() & this.hashFactor;
    }

    public void clear() {
        Arrays.fill(this.baseHash, 0);
        this.size = 0;
        this.values[0] = Float.NaN;
        this.firstEmpty = 1;
        int i = 1;
        while (i < this.capacity) {
            this.next[i++] = i;
        }
        this.next[this.capacity] = 0;
    }

    public boolean containsKey(K key) {
        return this.find(key) != 0;
    }

    public boolean containsValue(float o) {
        FloatIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (o != iterator.next()) continue;
            return true;
        }
        return false;
    }

    protected int find(K key) {
        int baseHashIndex = this.calcBaseHashIndex(key);
        int localIndex = this.baseHash[baseHashIndex];
        while (localIndex != 0) {
            if (this.keys[localIndex].equals(key)) {
                return localIndex;
            }
            localIndex = this.next[localIndex];
        }
        return 0;
    }

    private int findForRemove(K key, int baseHashIndex) {
        this.prev = 0;
        int index = this.baseHash[baseHashIndex];
        while (index != 0) {
            if (this.keys[index].equals(key)) {
                return index;
            }
            this.prev = index;
            index = this.next[index];
        }
        this.prev = 0;
        return 0;
    }

    public float get(K key) {
        return this.values[this.find(key)];
    }

    protected void grow() {
        ObjectToFloatMap<K> that = new ObjectToFloatMap<K>(this.capacity * 2);
        IndexIterator iterator = new IndexIterator();
        while (iterator.hasNext()) {
            int index = iterator.next();
            super.prvt_put(this.keys[index], this.values[index]);
        }
        this.capacity = that.capacity;
        this.size = that.size;
        this.firstEmpty = that.firstEmpty;
        this.values = that.values;
        this.keys = that.keys;
        this.next = that.next;
        this.baseHash = that.baseHash;
        this.hashFactor = that.hashFactor;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public FloatIterator iterator() {
        return new ValueIterator();
    }

    public Iterator<K> keyIterator() {
        return new KeyIterator();
    }

    private String getBaseHashAsString() {
        return Arrays.toString(this.baseHash);
    }

    public float put(K key, float e) {
        int index = this.find(key);
        if (index != 0) {
            float old = this.values[index];
            this.values[index] = e;
            return old;
        }
        if (this.size == this.capacity) {
            this.grow();
        }
        this.prvt_put(key, e);
        return Float.NaN;
    }

    public float remove(K key) {
        int baseHashIndex = this.calcBaseHashIndex(key);
        int index = this.findForRemove(key, baseHashIndex);
        if (index != 0) {
            if (this.prev == 0) {
                this.baseHash[baseHashIndex] = this.next[index];
            }
            this.next[this.prev] = this.next[index];
            this.next[index] = this.firstEmpty;
            this.firstEmpty = index;
            --this.size;
            return this.values[index];
        }
        return Float.NaN;
    }

    public int size() {
        return this.size;
    }

    public float[] toArray() {
        int j = -1;
        float[] array = new float[this.size];
        FloatIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            array[++j] = iterator.next();
        }
        return array;
    }

    public float[] toArray(float[] a) {
        int j;
        FloatIterator iterator = this.iterator();
        for (j = 0; j < a.length && iterator.hasNext(); ++j) {
            a[j] = iterator.next();
        }
        if (j < a.length) {
            a[j] = Float.NaN;
        }
        return a;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        Iterator<K> keyIterator = this.keyIterator();
        while (keyIterator.hasNext()) {
            K key = keyIterator.next();
            sb.append(key);
            sb.append('=');
            sb.append(this.get(key));
            if (!keyIterator.hasNext()) continue;
            sb.append(',');
            sb.append(' ');
        }
        sb.append('}');
        return sb.toString();
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.size();
    }

    public boolean equals(Object o) {
        ObjectToFloatMap that = (ObjectToFloatMap)o;
        if (that.size() != this.size()) {
            return false;
        }
        Iterator<K> it = this.keyIterator();
        while (it.hasNext()) {
            float v2;
            K key = it.next();
            float v1 = this.get(key);
            if (Float.compare(v1, v2 = that.get(key)) == 0) continue;
            return false;
        }
        return true;
    }

    private final class ValueIterator
    implements FloatIterator {
        private IntIterator iterator;

        ValueIterator() {
            this.iterator = new IndexIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public float next() {
            return ObjectToFloatMap.this.values[this.iterator.next()];
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private final class KeyIterator
    implements Iterator<K> {
        private IntIterator iterator;

        KeyIterator() {
            this.iterator = new IndexIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public K next() {
            return ObjectToFloatMap.this.keys[this.iterator.next()];
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private final class IndexIterator
    implements IntIterator {
        private int baseHashIndex = 0;
        private int index = 0;
        private int lastIndex = 0;

        public IndexIterator() {
            while (this.baseHashIndex < ObjectToFloatMap.this.baseHash.length) {
                this.index = ObjectToFloatMap.this.baseHash[this.baseHashIndex];
                if (this.index != 0) break;
                ++this.baseHashIndex;
            }
        }

        @Override
        public boolean hasNext() {
            return this.index != 0;
        }

        @Override
        public int next() {
            this.lastIndex = this.index;
            this.index = ObjectToFloatMap.this.next[this.index];
            while (this.index == 0 && ++this.baseHashIndex < ObjectToFloatMap.this.baseHash.length) {
                this.index = ObjectToFloatMap.this.baseHash[this.baseHashIndex];
            }
            return this.lastIndex;
        }

        @Override
        public void remove() {
            ObjectToFloatMap.this.remove(ObjectToFloatMap.this.keys[this.lastIndex]);
        }
    }
}

