/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.encoding;

import org.apache.lucene.facet.encoding.IntDecoder;
import org.apache.lucene.facet.encoding.IntEncoder;
import org.apache.lucene.facet.encoding.IntEncoderFilter;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;

public final class UniqueValuesIntEncoder
extends IntEncoderFilter {
    public UniqueValuesIntEncoder(IntEncoder encoder) {
        super(encoder);
    }

    @Override
    public void encode(IntsRef values, BytesRef buf) {
        int prev = values.ints[values.offset];
        int idx = values.offset + 1;
        int upto = values.offset + values.length;
        for (int i = idx; i < upto; ++i) {
            if (values.ints[i] == prev) continue;
            values.ints[idx++] = values.ints[i];
            prev = values.ints[i];
        }
        values.length = idx - values.offset;
        this.encoder.encode(values, buf);
    }

    @Override
    public IntDecoder createMatchingDecoder() {
        return this.encoder.createMatchingDecoder();
    }

    public String toString() {
        return "Unique(" + this.encoder.toString() + ")";
    }
}

