/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetResultNode;

public class FacetResult {
    private final FacetRequest facetRequest;
    private final FacetResultNode rootNode;
    private final int numValidDescendants;

    public FacetResult(FacetRequest facetRequest, FacetResultNode rootNode, int numValidDescendants) {
        this.facetRequest = facetRequest;
        this.rootNode = rootNode;
        this.numValidDescendants = numValidDescendants;
    }

    public final FacetResultNode getFacetResultNode() {
        return this.rootNode;
    }

    public final int getNumValidDescendants() {
        return this.numValidDescendants;
    }

    public final FacetRequest getFacetRequest() {
        return this.facetRequest;
    }

    public String toString(String prefix) {
        StringBuilder sb = new StringBuilder();
        String nl = "";
        if (this.facetRequest != null) {
            sb.append(nl).append(prefix).append("Request: ").append(this.facetRequest.toString());
            nl = "\n";
        }
        sb.append(nl).append(prefix).append("Num valid Descendants (up to specified depth): ").append(this.numValidDescendants);
        nl = "\n";
        if (this.rootNode != null) {
            sb.append(nl).append(this.rootNode.toString(prefix + "\t"));
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

