/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.lucene.facet.params.FacetSearchParams;
import org.apache.lucene.facet.search.DrillDownQuery;
import org.apache.lucene.facet.search.DrillSidewaysQuery;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetResult;
import org.apache.lucene.facet.search.FacetsAccumulator;
import org.apache.lucene.facet.search.FacetsCollector;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;

public class DrillSideways {
    protected final IndexSearcher searcher;
    protected final TaxonomyReader taxoReader;

    public DrillSideways(IndexSearcher searcher, TaxonomyReader taxoReader) {
        this.searcher = searcher;
        this.taxoReader = taxoReader;
    }

    private static DrillDownQuery moveDrillDownOnlyClauses(DrillDownQuery in, FacetSearchParams fsp) {
        int startClause;
        Map<String, Integer> drillDownDims;
        HashSet<String> facetDims = new HashSet<String>();
        for (FacetRequest fr : fsp.facetRequests) {
            if (fr.categoryPath.length == 0) {
                throw new IllegalArgumentException("all FacetRequests must have CategoryPath with length > 0");
            }
            facetDims.add(fr.categoryPath.components[0]);
        }
        BooleanClause[] clauses = in.getBooleanQuery().getClauses();
        if (clauses.length == (drillDownDims = in.getDims()).size()) {
            startClause = 0;
        } else {
            assert (clauses.length == 1 + drillDownDims.size());
            startClause = 1;
        }
        ArrayList<Query> nonFacetClauses = new ArrayList<Query>();
        ArrayList<Query> facetClauses = new ArrayList<Query>();
        for (int i = startClause; i < clauses.length; ++i) {
            Query q = clauses[i].getQuery();
            String dim = in.getDim(q);
            if (!facetDims.contains(dim)) {
                nonFacetClauses.add(q);
                continue;
            }
            facetClauses.add(q);
        }
        if (!nonFacetClauses.isEmpty()) {
            BooleanQuery newBaseQuery = new BooleanQuery(true);
            if (startClause == 1) {
                newBaseQuery.add(clauses[0].getQuery(), BooleanClause.Occur.MUST);
            }
            for (Query q : nonFacetClauses) {
                newBaseQuery.add(q, BooleanClause.Occur.MUST);
            }
            return new DrillDownQuery(fsp.indexingParams, (Query)newBaseQuery, facetClauses);
        }
        return in;
    }

    public DrillSidewaysResult search(DrillDownQuery query, Collector hitCollector, FacetSearchParams fsp) throws IOException {
        int startClause;
        MatchAllDocsQuery baseQuery;
        if (query.fip != fsp.indexingParams) {
            throw new IllegalArgumentException("DrillDownQuery's FacetIndexingParams should match FacetSearchParams'");
        }
        Map<String, Integer> drillDownDims = (query = DrillSideways.moveDrillDownOnlyClauses(query, fsp)).getDims();
        if (drillDownDims.isEmpty()) {
            FacetsCollector c = FacetsCollector.create(this.getDrillDownAccumulator(fsp));
            this.searcher.search((Query)query, MultiCollector.wrap((Collector[])new Collector[]{hitCollector, c}));
            return new DrillSidewaysResult(c.getFacetResults(), null);
        }
        BooleanQuery ddq = query.getBooleanQuery();
        BooleanClause[] clauses = ddq.getClauses();
        if (clauses.length == drillDownDims.size()) {
            baseQuery = new MatchAllDocsQuery();
            startClause = 0;
        } else {
            assert (clauses.length == 1 + drillDownDims.size());
            baseQuery = clauses[0].getQuery();
            startClause = 1;
        }
        Term[][] drillDownTerms = new Term[clauses.length - startClause][];
        for (int i = startClause; i < clauses.length; ++i) {
            Query q = clauses[i].getQuery();
            assert (q instanceof ConstantScoreQuery);
            q = ((ConstantScoreQuery)q).getQuery();
            assert (q instanceof TermQuery || q instanceof BooleanQuery);
            if (q instanceof TermQuery) {
                drillDownTerms[i - startClause] = new Term[]{((TermQuery)q).getTerm()};
                continue;
            }
            BooleanQuery q2 = (BooleanQuery)q;
            BooleanClause[] clauses2 = q2.getClauses();
            drillDownTerms[i - startClause] = new Term[clauses2.length];
            for (int j = 0; j < clauses2.length; ++j) {
                assert (clauses2[j].getQuery() instanceof TermQuery);
                drillDownTerms[i - startClause][j] = ((TermQuery)clauses2[j].getQuery()).getTerm();
            }
        }
        FacetsCollector drillDownCollector = FacetsCollector.create(this.getDrillDownAccumulator(fsp));
        Collector[] drillSidewaysCollectors = new FacetsCollector[drillDownDims.size()];
        int idx = 0;
        for (String dim : drillDownDims.keySet()) {
            ArrayList<FacetRequest> requests = new ArrayList<FacetRequest>();
            for (FacetRequest fr : fsp.facetRequests) {
                assert (fr.categoryPath.length > 0);
                if (!fr.categoryPath.components[0].equals(dim)) continue;
                requests.add(fr);
            }
            if (requests.isEmpty()) {
                throw new IllegalArgumentException("could not find FacetRequest for drill-sideways dimension \"" + dim + "\"");
            }
            drillSidewaysCollectors[idx++] = FacetsCollector.create(this.getDrillSidewaysAccumulator(dim, new FacetSearchParams(fsp.indexingParams, requests)));
        }
        DrillSidewaysQuery dsq = new DrillSidewaysQuery((Query)baseQuery, drillDownCollector, drillSidewaysCollectors, drillDownTerms);
        this.searcher.search((Query)dsq, hitCollector);
        int numDims = drillDownDims.size();
        List[] drillSidewaysResults = new List[numDims];
        List<FacetResult> drillDownResults = null;
        ArrayList<FacetResult> mergedResults = new ArrayList<FacetResult>();
        int[] requestUpto = new int[drillDownDims.size()];
        for (int i = 0; i < fsp.facetRequests.size(); ++i) {
            FacetRequest fr = fsp.facetRequests.get(i);
            assert (fr.categoryPath.length > 0);
            Integer dimIndex = drillDownDims.get(fr.categoryPath.components[0]);
            if (dimIndex == null) {
                if (drillDownResults == null) {
                    drillDownResults = drillDownCollector.getFacetResults();
                }
                mergedResults.add(drillDownResults.get(i));
                continue;
            }
            int dim = dimIndex;
            List<FacetResult> sidewaysResult = drillSidewaysResults[dim];
            if (sidewaysResult == null) {
                drillSidewaysResults[dim] = sidewaysResult = drillSidewaysCollectors[dim].getFacetResults();
            }
            mergedResults.add(sidewaysResult.get(requestUpto[dim]));
            int n = dim;
            requestUpto[n] = requestUpto[n] + 1;
        }
        return new DrillSidewaysResult(mergedResults, null);
    }

    public DrillSidewaysResult search(DrillDownQuery query, Filter filter, FieldDoc after, int topN, Sort sort, boolean doDocScores, boolean doMaxScore, FacetSearchParams fsp) throws IOException {
        if (filter != null) {
            query = new DrillDownQuery(filter, query);
        }
        if (sort != null) {
            TopFieldCollector hitCollector = TopFieldCollector.create((Sort)sort, (int)Math.min(topN, this.searcher.getIndexReader().maxDoc()), (FieldDoc)after, (boolean)true, (boolean)doDocScores, (boolean)doMaxScore, (boolean)true);
            DrillSidewaysResult r = this.search(query, (Collector)hitCollector, fsp);
            r.hits = hitCollector.topDocs();
            return r;
        }
        return this.search((ScoreDoc)after, query, topN, fsp);
    }

    public DrillSidewaysResult search(ScoreDoc after, DrillDownQuery query, int topN, FacetSearchParams fsp) throws IOException {
        TopScoreDocCollector hitCollector = TopScoreDocCollector.create((int)Math.min(topN, this.searcher.getIndexReader().maxDoc()), (ScoreDoc)after, (boolean)true);
        DrillSidewaysResult r = this.search(query, (Collector)hitCollector, fsp);
        r.hits = hitCollector.topDocs();
        return r;
    }

    protected FacetsAccumulator getDrillDownAccumulator(FacetSearchParams fsp) throws IOException {
        return FacetsAccumulator.create(fsp, this.searcher.getIndexReader(), this.taxoReader);
    }

    protected FacetsAccumulator getDrillSidewaysAccumulator(String dim, FacetSearchParams fsp) throws IOException {
        return FacetsAccumulator.create(fsp, this.searcher.getIndexReader(), this.taxoReader);
    }

    public static class DrillSidewaysResult {
        public final List<FacetResult> facetResults;
        public TopDocs hits;

        DrillSidewaysResult(List<FacetResult> facetResults, TopDocs hits) {
            this.facetResults = facetResults;
            this.hits = hits;
        }
    }
}

