/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.sampling;

import java.io.IOException;
import org.apache.lucene.facet.params.FacetSearchParams;
import org.apache.lucene.facet.sampling.SampleFixer;
import org.apache.lucene.facet.search.DrillDownQuery;
import org.apache.lucene.facet.search.FacetResultNode;
import org.apache.lucene.facet.search.ScoredDocIDs;
import org.apache.lucene.facet.search.ScoredDocIDsIterator;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;

public class TakmiSampleFixer
extends SampleFixer {
    private TaxonomyReader taxonomyReader;
    private IndexReader indexReader;
    private FacetSearchParams searchParams;

    public TakmiSampleFixer(IndexReader indexReader, TaxonomyReader taxonomyReader, FacetSearchParams searchParams) {
        this.indexReader = indexReader;
        this.taxonomyReader = taxonomyReader;
        this.searchParams = searchParams;
    }

    @Override
    public void singleNodeFix(FacetResultNode facetResNode, ScoredDocIDs docIds, double samplingRatio) throws IOException {
        this.recount(facetResNode, docIds);
    }

    private void recount(FacetResultNode fresNode, ScoredDocIDs docIds) throws IOException {
        if (fresNode.label == null) {
            fresNode.label = this.taxonomyReader.getPath(fresNode.ordinal);
        }
        CategoryPath catPath = fresNode.label;
        Term drillDownTerm = DrillDownQuery.term(this.searchParams.indexingParams, catPath);
        Bits liveDocs = MultiFields.getLiveDocs((IndexReader)this.indexReader);
        int updatedCount = TakmiSampleFixer.countIntersection(MultiFields.getTermDocsEnum((IndexReader)this.indexReader, (Bits)liveDocs, (String)drillDownTerm.field(), (BytesRef)drillDownTerm.bytes(), (int)0), docIds.iterator());
        fresNode.value = updatedCount;
    }

    private static int countIntersection(DocsEnum p1, ScoredDocIDsIterator p2) throws IOException {
        if (p1 == null || p1.nextDoc() == Integer.MAX_VALUE) {
            return 0;
        }
        if (!p2.next()) {
            return 0;
        }
        int d1 = p1.docID();
        int d2 = p2.getDocID();
        int count = 0;
        while (true) {
            if (d1 == d2) {
                ++count;
                if (p1.nextDoc() == Integer.MAX_VALUE || !TakmiSampleFixer.advance(p2, d1 = p1.docID())) break;
                d2 = p2.getDocID();
                continue;
            }
            if (d1 < d2) {
                if (p1.advance(d2) == Integer.MAX_VALUE) break;
                d1 = p1.docID();
                continue;
            }
            if (!TakmiSampleFixer.advance(p2, d1)) break;
            d2 = p2.getDocID();
        }
        return count;
    }

    private static boolean advance(ScoredDocIDsIterator iterator, int targetDoc) {
        while (iterator.next()) {
            if (iterator.getDocID() < targetDoc) continue;
            return true;
        }
        return false;
    }
}

