/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.Facets;

public class MultiFacets
extends Facets {
    private final Map<String, Facets> dimToFacets;
    private final Facets defaultFacets;

    public MultiFacets(Map<String, Facets> dimToFacets) {
        this(dimToFacets, null);
    }

    public MultiFacets(Map<String, Facets> dimToFacets, Facets defaultFacets) {
        this.dimToFacets = dimToFacets;
        this.defaultFacets = defaultFacets;
    }

    @Override
    public FacetResult getTopChildren(int topN, String dim, String ... path) throws IOException {
        Facets facets = this.dimToFacets.get(dim);
        if (facets == null) {
            if (this.defaultFacets == null) {
                throw new IllegalArgumentException("invalid dim \"" + dim + "\"");
            }
            facets = this.defaultFacets;
        }
        return facets.getTopChildren(topN, dim, path);
    }

    @Override
    public Number getSpecificValue(String dim, String ... path) throws IOException {
        Facets facets = this.dimToFacets.get(dim);
        if (facets == null) {
            if (this.defaultFacets == null) {
                throw new IllegalArgumentException("invalid dim \"" + dim + "\"");
            }
            facets = this.defaultFacets;
        }
        return facets.getSpecificValue(dim, path);
    }

    @Override
    public List<FacetResult> getAllDims(int topN) throws IOException {
        throw new UnsupportedOperationException();
    }
}

