/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.range;

import java.io.IOException;
import java.util.Collections;
import org.apache.lucene.facet.range.LongRange;
import org.apache.lucene.facet.range.Range;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredDocIdSet;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.NumericUtils;

public final class DoubleRange
extends Range {
    final double minIncl;
    final double maxIncl;
    public final double min;
    public final double max;
    public final boolean minInclusive;
    public final boolean maxInclusive;

    public DoubleRange(String label, double minIn, boolean minInclusive, double maxIn, boolean maxInclusive) {
        super(label);
        this.min = minIn;
        this.max = maxIn;
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
        if (Double.isNaN(this.min)) {
            throw new IllegalArgumentException("min cannot be NaN");
        }
        if (!minInclusive) {
            minIn = Math.nextUp(minIn);
        }
        if (Double.isNaN(this.max)) {
            throw new IllegalArgumentException("max cannot be NaN");
        }
        if (!maxInclusive) {
            maxIn = Math.nextAfter(maxIn, Double.NEGATIVE_INFINITY);
        }
        if (minIn > maxIn) {
            this.failNoMatch();
        }
        this.minIncl = minIn;
        this.maxIncl = maxIn;
    }

    public boolean accept(double value) {
        return value >= this.minIncl && value <= this.maxIncl;
    }

    LongRange toLongRange() {
        return new LongRange(this.label, NumericUtils.doubleToSortableLong((double)this.minIncl), true, NumericUtils.doubleToSortableLong((double)this.maxIncl), true);
    }

    public String toString() {
        return "DoubleRange(" + this.minIncl + " to " + this.maxIncl + ")";
    }

    @Override
    public Filter getFilter(final Filter fastMatchFilter, final ValueSource valueSource) {
        return new Filter(){

            public String toString(String field) {
                return "Filter(" + DoubleRange.this.toString() + ")";
            }

            public DocIdSet getDocIdSet(LeafReaderContext context, final Bits acceptDocs) throws IOException {
                DocIdSet fastMatchDocs;
                final FunctionValues values = valueSource.getValues(Collections.emptyMap(), context);
                final int maxDoc = context.reader().maxDoc();
                if (fastMatchFilter != null) {
                    fastMatchDocs = fastMatchFilter.getDocIdSet(context, null);
                    if (fastMatchDocs == null) {
                        return null;
                    }
                } else {
                    fastMatchDocs = new DocIdSet(){

                        public long ramBytesUsed() {
                            return 0L;
                        }

                        public DocIdSetIterator iterator() throws IOException {
                            return DocIdSetIterator.all((int)maxDoc);
                        }
                    };
                }
                return new FilteredDocIdSet(fastMatchDocs){

                    protected boolean match(int docID) {
                        if (acceptDocs != null && !acceptDocs.get(docID)) {
                            return false;
                        }
                        return DoubleRange.this.accept(values.doubleVal(docID));
                    }
                };
            }
        };
    }
}

