/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;

class DrillSidewaysScorer
extends BulkScorer {
    private final Collector drillDownCollector;
    private LeafCollector drillDownLeafCollector;
    private final DocsAndCost[] dims;
    private final Scorer baseScorer;
    private final LeafReaderContext context;
    final boolean scoreSubDocsAtOnce;
    private static final int CHUNK = 2048;
    private static final int MASK = 2047;
    private int collectDocID = -1;
    private float collectScore;

    DrillSidewaysScorer(LeafReaderContext context, Scorer baseScorer, Collector drillDownCollector, DocsAndCost[] dims, boolean scoreSubDocsAtOnce) {
        this.dims = dims;
        this.context = context;
        this.baseScorer = baseScorer;
        this.drillDownCollector = drillDownCollector;
        this.scoreSubDocsAtOnce = scoreSubDocsAtOnce;
    }

    public long cost() {
        return this.baseScorer.cost();
    }

    public int score(LeafCollector collector, int min, int maxDoc) throws IOException {
        if (min != 0) {
            throw new IllegalArgumentException("min must be 0, got " + min);
        }
        if (maxDoc != Integer.MAX_VALUE) {
            throw new IllegalArgumentException("maxDoc must be Integer.MAX_VALUE");
        }
        FakeScorer scorer = new FakeScorer();
        collector.setScorer((Scorer)scorer);
        if (this.drillDownCollector != null) {
            this.drillDownLeafCollector = this.drillDownCollector.getLeafCollector(this.context);
            this.drillDownLeafCollector.setScorer((Scorer)scorer);
        } else {
            this.drillDownLeafCollector = null;
        }
        for (DocsAndCost dim : this.dims) {
            dim.sidewaysLeafCollector = dim.sidewaysCollector.getLeafCollector(this.context);
            dim.sidewaysLeafCollector.setScorer((Scorer)scorer);
        }
        assert (this.baseScorer != null);
        long baseQueryCost = this.baseScorer.cost();
        int numDims = this.dims.length;
        long drillDownCost = 0L;
        for (int dim = 0; dim < numDims; ++dim) {
            DocIdSetIterator disi = this.dims[dim].disi;
            if (this.dims[dim].bits != null || disi == null) continue;
            drillDownCost += disi.cost();
        }
        long drillDownAdvancedCost = 0L;
        if (numDims > 1 && this.dims[1].disi != null) {
            drillDownAdvancedCost = this.dims[1].disi.cost();
        }
        this.baseScorer.nextDoc();
        int numBits = 0;
        for (DocsAndCost dim : this.dims) {
            if (dim.disi != null) {
                dim.disi.nextDoc();
                continue;
            }
            if (dim.bits == null) continue;
            ++numBits;
        }
        Bits[] bits = new Bits[numBits];
        LeafCollector[] bitsSidewaysCollectors = new LeafCollector[numBits];
        DocIdSetIterator[] disis = new DocIdSetIterator[numDims - numBits];
        LeafCollector[] sidewaysCollectors = new LeafCollector[numDims - numBits];
        int disiUpto = 0;
        int bitsUpto = 0;
        for (int dim = 0; dim < numDims; ++dim) {
            DocIdSetIterator disi = this.dims[dim].disi;
            if (this.dims[dim].bits == null) {
                disis[disiUpto] = disi;
                sidewaysCollectors[disiUpto] = this.dims[dim].sidewaysLeafCollector;
                ++disiUpto;
                continue;
            }
            bits[bitsUpto] = this.dims[dim].bits;
            bitsSidewaysCollectors[bitsUpto] = this.dims[dim].sidewaysLeafCollector;
            ++bitsUpto;
        }
        if (bitsUpto > 0 || this.scoreSubDocsAtOnce || baseQueryCost < drillDownCost / 10L) {
            this.doQueryFirstScoring(collector, disis, sidewaysCollectors, bits, bitsSidewaysCollectors);
        } else if (numDims > 1 && (this.dims[1].disi == null || drillDownAdvancedCost < baseQueryCost / 10L)) {
            this.doDrillDownAdvanceScoring(collector, disis, sidewaysCollectors);
        } else {
            this.doUnionScoring(collector, disis, sidewaysCollectors);
        }
        return Integer.MAX_VALUE;
    }

    private void doQueryFirstScoring(LeafCollector collector, DocIdSetIterator[] disis, LeafCollector[] sidewaysCollectors, Bits[] bits, LeafCollector[] bitsSidewaysCollectors) throws IOException {
        int docID = this.baseScorer.docID();
        block0: while (docID != Integer.MAX_VALUE) {
            int i;
            LeafCollector failedCollector = null;
            for (i = 0; i < disis.length; ++i) {
                DocIdSetIterator disi = disis[i];
                if (disi != null && disi.docID() < docID) {
                    disi.advance(docID);
                }
                if (disi != null && disi.docID() <= docID) continue;
                if (failedCollector != null) {
                    docID = this.baseScorer.nextDoc();
                    continue block0;
                }
                failedCollector = sidewaysCollectors[i];
            }
            for (i = 0; i < bits.length; ++i) {
                if (bits[i].get(docID)) continue;
                if (failedCollector != null) {
                    docID = this.baseScorer.nextDoc();
                    continue block0;
                }
                failedCollector = bitsSidewaysCollectors[i];
            }
            this.collectDocID = docID;
            this.collectScore = this.baseScorer.score();
            if (failedCollector == null) {
                this.collectHit(collector, sidewaysCollectors, bitsSidewaysCollectors);
            } else {
                this.collectNearMiss(failedCollector);
            }
            docID = this.baseScorer.nextDoc();
        }
    }

    private void doDrillDownAdvanceScoring(LeafCollector collector, DocIdSetIterator[] disis, LeafCollector[] sidewaysCollectors) throws IOException {
        int maxDoc = this.context.reader().maxDoc();
        int numDims = this.dims.length;
        int[] filledSlots = new int[2048];
        int[] docIDs = new int[2048];
        float[] scores = new float[2048];
        int[] missingDims = new int[2048];
        int[] counts = new int[2048];
        docIDs[0] = -1;
        int nextChunkStart = 2048;
        FixedBitSet seen = new FixedBitSet(2048);
        while (true) {
            int slot;
            int docID;
            DocIdSetIterator disi;
            if ((disi = disis[0]) != null) {
                docID = disi.docID();
                while (docID < nextChunkStart) {
                    slot = docID & 0x7FF;
                    if (docIDs[slot] != docID) {
                        seen.set(slot);
                        docIDs[slot] = docID;
                        missingDims[slot] = 1;
                        counts[slot] = 1;
                    }
                    docID = disi.nextDoc();
                }
            }
            if ((disi = disis[1]) != null) {
                docID = disi.docID();
                while (docID < nextChunkStart) {
                    slot = docID & 0x7FF;
                    if (docIDs[slot] != docID) {
                        seen.set(slot);
                        docIDs[slot] = docID;
                        missingDims[slot] = 0;
                        counts[slot] = 1;
                    } else if (missingDims[slot] >= 1) {
                        missingDims[slot] = 2;
                        counts[slot] = 2;
                    } else {
                        counts[slot] = 1;
                    }
                    docID = disi.nextDoc();
                }
            }
            int filledCount = 0;
            for (int slot0 = 0; slot0 < 2048 && (slot0 = seen.nextSetBit(slot0)) != Integer.MAX_VALUE; ++slot0) {
                int ddDocID = docIDs[slot0];
                assert (ddDocID != -1);
                int baseDocID = this.baseScorer.docID();
                if (baseDocID < ddDocID) {
                    baseDocID = this.baseScorer.advance(ddDocID);
                }
                if (baseDocID == ddDocID) {
                    scores[slot0] = this.baseScorer.score();
                    filledSlots[filledCount++] = slot0;
                    int n = slot0;
                    counts[n] = counts[n] + 1;
                    continue;
                }
                docIDs[slot0] = -1;
            }
            seen.clear(0, 2048);
            if (filledCount == 0) {
                if (nextChunkStart >= maxDoc) break;
                nextChunkStart += 2048;
                continue;
            }
            for (int dim = 2; dim < numDims; ++dim) {
                disi = disis[dim];
                if (disi == null) continue;
                int docID2 = disi.docID();
                while (docID2 < nextChunkStart) {
                    int slot2 = docID2 & 0x7FF;
                    if (docIDs[slot2] == docID2 && counts[slot2] >= dim) {
                        if (missingDims[slot2] >= dim) {
                            missingDims[slot2] = dim + 1;
                            counts[slot2] = dim + 2;
                        } else {
                            counts[slot2] = dim + 1;
                        }
                    }
                    docID2 = disi.nextDoc();
                }
            }
            for (int i = 0; i < filledCount; ++i) {
                int slot3 = filledSlots[i];
                this.collectDocID = docIDs[slot3];
                this.collectScore = scores[slot3];
                if (counts[slot3] == 1 + numDims) {
                    this.collectHit(collector, sidewaysCollectors);
                    continue;
                }
                if (counts[slot3] != numDims) continue;
                this.collectNearMiss(sidewaysCollectors[missingDims[slot3]]);
            }
            if (nextChunkStart >= maxDoc) break;
            nextChunkStart += 2048;
        }
    }

    private void doUnionScoring(LeafCollector collector, DocIdSetIterator[] disis, LeafCollector[] sidewaysCollectors) throws IOException {
        int maxDoc = this.context.reader().maxDoc();
        int numDims = this.dims.length;
        int[] filledSlots = new int[2048];
        int[] docIDs = new int[2048];
        float[] scores = new float[2048];
        int[] missingDims = new int[2048];
        int[] counts = new int[2048];
        docIDs[0] = -1;
        int nextChunkStart = 2048;
        while (true) {
            int slot;
            int filledCount = 0;
            int docID = this.baseScorer.docID();
            while (docID < nextChunkStart) {
                int slot2 = docID & 0x7FF;
                assert (docIDs[slot2] != docID) : "slot=" + slot2 + " docID=" + docID;
                docIDs[slot2] = docID;
                scores[slot2] = this.baseScorer.score();
                filledSlots[filledCount++] = slot2;
                missingDims[slot2] = 0;
                counts[slot2] = 1;
                docID = this.baseScorer.nextDoc();
            }
            if (filledCount == 0) {
                if (nextChunkStart >= maxDoc) break;
                nextChunkStart += 2048;
                continue;
            }
            DocIdSetIterator disi = disis[0];
            if (disi != null) {
                docID = disi.docID();
                while (docID < nextChunkStart) {
                    int slot3 = docID & 0x7FF;
                    if (docIDs[slot3] == docID) {
                        missingDims[slot3] = 1;
                        counts[slot3] = 2;
                    }
                    docID = disi.nextDoc();
                }
            }
            for (int dim = 1; dim < numDims; ++dim) {
                disi = disis[dim];
                if (disi == null) continue;
                docID = disi.docID();
                while (docID < nextChunkStart) {
                    slot = docID & 0x7FF;
                    if (docIDs[slot] == docID && counts[slot] >= dim) {
                        if (missingDims[slot] >= dim) {
                            missingDims[slot] = dim + 1;
                            counts[slot] = dim + 2;
                        } else {
                            counts[slot] = dim + 1;
                        }
                    }
                    docID = disi.nextDoc();
                }
            }
            for (int i = 0; i < filledCount; ++i) {
                slot = filledSlots[i];
                this.collectDocID = docIDs[slot];
                this.collectScore = scores[slot];
                if (counts[slot] == 1 + numDims) {
                    this.collectHit(collector, sidewaysCollectors);
                    continue;
                }
                if (counts[slot] != numDims) continue;
                this.collectNearMiss(sidewaysCollectors[missingDims[slot]]);
            }
            if (nextChunkStart >= maxDoc) break;
            nextChunkStart += 2048;
        }
    }

    private void collectHit(LeafCollector collector, LeafCollector[] sidewaysCollectors) throws IOException {
        collector.collect(this.collectDocID);
        if (this.drillDownCollector != null) {
            this.drillDownLeafCollector.collect(this.collectDocID);
        }
        for (int dim = 0; dim < sidewaysCollectors.length; ++dim) {
            sidewaysCollectors[dim].collect(this.collectDocID);
        }
    }

    private void collectHit(LeafCollector collector, LeafCollector[] sidewaysCollectors, LeafCollector[] sidewaysCollectors2) throws IOException {
        int i;
        collector.collect(this.collectDocID);
        if (this.drillDownCollector != null) {
            this.drillDownLeafCollector.collect(this.collectDocID);
        }
        for (i = 0; i < sidewaysCollectors.length; ++i) {
            sidewaysCollectors[i].collect(this.collectDocID);
        }
        for (i = 0; i < sidewaysCollectors2.length; ++i) {
            sidewaysCollectors2[i].collect(this.collectDocID);
        }
    }

    private void collectNearMiss(LeafCollector sidewaysCollector) throws IOException {
        sidewaysCollector.collect(this.collectDocID);
    }

    static class DocsAndCost
    implements Comparable<DocsAndCost> {
        DocIdSetIterator disi;
        Bits bits;
        Collector sidewaysCollector;
        LeafCollector sidewaysLeafCollector;
        String dim;

        DocsAndCost() {
        }

        @Override
        public int compareTo(DocsAndCost other) {
            if (this.disi == null) {
                if (other.disi == null) {
                    return 0;
                }
                return 1;
            }
            if (other.disi == null) {
                return -1;
            }
            if (this.disi.cost() < other.disi.cost()) {
                return -1;
            }
            if (this.disi.cost() > other.disi.cost()) {
                return 1;
            }
            return 0;
        }
    }

    private final class FakeScorer
    extends Scorer {
        public FakeScorer() {
            super(null);
        }

        public int advance(int target) {
            throw new UnsupportedOperationException("FakeScorer doesn't support advance(int)");
        }

        public int docID() {
            return DrillSidewaysScorer.this.collectDocID;
        }

        public int freq() {
            return 1 + DrillSidewaysScorer.this.dims.length;
        }

        public int nextDoc() {
            throw new UnsupportedOperationException("FakeScorer doesn't support nextDoc()");
        }

        public float score() {
            return DrillSidewaysScorer.this.collectScore;
        }

        public long cost() {
            return DrillSidewaysScorer.this.baseScorer.cost();
        }

        public Collection<Scorer.ChildScorer> getChildren() {
            return Collections.singletonList(new Scorer.ChildScorer(DrillSidewaysScorer.this.baseScorer, "MUST"));
        }

        public Weight getWeight() {
            throw new UnsupportedOperationException();
        }
    }
}

