/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public final class DrillDownQuery
extends Query {
    private final FacetsConfig config;
    private final Query baseQuery;
    private final List<BooleanQuery.Builder> dimQueries = new ArrayList<BooleanQuery.Builder>();
    private final Map<String, Integer> drillDownDims = new LinkedHashMap<String, Integer>();

    public static Term term(String field, String dim, String ... path) {
        return new Term(field, FacetsConfig.pathToString(dim, path));
    }

    DrillDownQuery(FacetsConfig config, Query baseQuery, List<BooleanQuery.Builder> dimQueries, Map<String, Integer> drillDownDims) {
        this.baseQuery = baseQuery;
        this.dimQueries.addAll(dimQueries);
        this.drillDownDims.putAll(drillDownDims);
        this.config = config;
    }

    DrillDownQuery(FacetsConfig config, Query filter, DrillDownQuery other) {
        this.baseQuery = new BooleanQuery.Builder().add((Query)(other.baseQuery == null ? new MatchAllDocsQuery() : other.baseQuery), BooleanClause.Occur.MUST).add(filter, BooleanClause.Occur.FILTER).build();
        this.dimQueries.addAll(other.dimQueries);
        this.drillDownDims.putAll(other.drillDownDims);
        this.config = config;
    }

    public DrillDownQuery(FacetsConfig config) {
        this(config, null);
    }

    public DrillDownQuery(FacetsConfig config, Query baseQuery) {
        this.baseQuery = baseQuery;
        this.config = config;
    }

    public void add(String dim, String ... path) {
        String indexedField = this.config.getDimConfig((String)dim).indexFieldName;
        this.add(dim, (Query)new TermQuery(DrillDownQuery.term(indexedField, dim, path)));
    }

    public void add(String dim, Query subQuery) {
        assert (this.drillDownDims.size() == this.dimQueries.size());
        if (!this.drillDownDims.containsKey(dim)) {
            this.drillDownDims.put(dim, this.drillDownDims.size());
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.setDisableCoord(true);
            this.dimQueries.add(builder);
        }
        int index = this.drillDownDims.get(dim);
        this.dimQueries.get(index).add(subQuery, BooleanClause.Occur.SHOULD);
    }

    public DrillDownQuery clone() {
        return new DrillDownQuery(this.config, this.baseQuery, this.dimQueries, this.drillDownDims);
    }

    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(this.baseQuery, this.dimQueries);
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        DrillDownQuery other = (DrillDownQuery)((Object)obj);
        return Objects.equals(this.baseQuery, other.baseQuery) && this.dimQueries.equals(other.dimQueries);
    }

    public Query rewrite(IndexReader r) throws IOException {
        BooleanQuery rewritten = this.getBooleanQuery();
        if (rewritten.clauses().isEmpty()) {
            return new MatchAllDocsQuery();
        }
        return rewritten;
    }

    public String toString(String field) {
        return this.getBooleanQuery().toString(field);
    }

    private BooleanQuery getBooleanQuery() {
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        if (this.baseQuery != null) {
            bq.add(this.baseQuery, BooleanClause.Occur.MUST);
        }
        for (BooleanQuery.Builder builder : this.dimQueries) {
            bq.add((Query)builder.build(), BooleanClause.Occur.FILTER);
        }
        return bq.build();
    }

    Query getBaseQuery() {
        return this.baseQuery;
    }

    Query[] getDrillDownQueries() {
        Query[] dimQueries = new Query[this.dimQueries.size()];
        for (int i = 0; i < dimQueries.length; ++i) {
            dimQueries[i] = this.dimQueries.get(i).build();
        }
        return dimQueries;
    }

    Map<String, Integer> getDims() {
        return this.drillDownDims;
    }
}

