/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.range;

import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import org.apache.lucene.facet.range.LongRange;
import org.apache.lucene.facet.range.Range;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.NumericUtils;

public final class DoubleRange
extends Range {
    public final double min;
    public final double max;

    public DoubleRange(String label, double minIn, boolean minInclusive, double maxIn, boolean maxInclusive) {
        super(label);
        if (Double.isNaN(minIn)) {
            throw new IllegalArgumentException("min cannot be NaN");
        }
        if (!minInclusive) {
            minIn = Math.nextUp(minIn);
        }
        if (Double.isNaN(maxIn)) {
            throw new IllegalArgumentException("max cannot be NaN");
        }
        if (!maxInclusive) {
            maxIn = Math.nextAfter(maxIn, Double.NEGATIVE_INFINITY);
        }
        if (minIn > maxIn) {
            this.failNoMatch();
        }
        this.min = minIn;
        this.max = maxIn;
    }

    public boolean accept(double value) {
        return value >= this.min && value <= this.max;
    }

    LongRange toLongRange() {
        return new LongRange(this.label, NumericUtils.doubleToSortableLong((double)this.min), true, NumericUtils.doubleToSortableLong((double)this.max), true);
    }

    public String toString() {
        return "DoubleRange(" + this.min + " to " + this.max + ")";
    }

    @Override
    public Query getQuery(Query fastMatchQuery, ValueSource valueSource) {
        return new ValueSourceQuery(this, fastMatchQuery, valueSource);
    }

    private static class ValueSourceQuery
    extends Query {
        private final DoubleRange range;
        private final Query fastMatchQuery;
        private final ValueSource valueSource;

        ValueSourceQuery(DoubleRange range, Query fastMatchQuery, ValueSource valueSource) {
            this.range = range;
            this.fastMatchQuery = fastMatchQuery;
            this.valueSource = valueSource;
        }

        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            ValueSourceQuery other = (ValueSourceQuery)((Object)obj);
            return this.range.equals(other.range) && Objects.equals(this.fastMatchQuery, other.fastMatchQuery) && this.valueSource.equals((Object)other.valueSource);
        }

        public int hashCode() {
            return 31 * Objects.hash(this.range, this.fastMatchQuery, this.valueSource) + super.hashCode();
        }

        public String toString(String field) {
            return "Filter(" + this.range.toString() + ")";
        }

        public Query rewrite(IndexReader reader) throws IOException {
            Query fastMatchRewritten;
            if (this.fastMatchQuery != null && (fastMatchRewritten = this.fastMatchQuery.rewrite(reader)) != this.fastMatchQuery) {
                return new ValueSourceQuery(this.range, fastMatchRewritten, this.valueSource);
            }
            return super.rewrite(reader);
        }

        public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
            final Weight fastMatchWeight = this.fastMatchQuery == null ? null : searcher.createWeight(this.fastMatchQuery, false);
            return new ConstantScoreWeight(this){

                public Scorer scorer(LeafReaderContext context) throws IOException {
                    DocIdSetIterator approximation;
                    int maxDoc = context.reader().maxDoc();
                    if (fastMatchWeight == null) {
                        approximation = DocIdSetIterator.all((int)maxDoc);
                    } else {
                        Scorer s = fastMatchWeight.scorer(context);
                        if (s == null) {
                            return null;
                        }
                        approximation = s.iterator();
                    }
                    final FunctionValues values = valueSource.getValues(Collections.emptyMap(), context);
                    TwoPhaseIterator twoPhase = new TwoPhaseIterator(approximation){

                        public boolean matches() throws IOException {
                            return range.accept(values.doubleVal(this.approximation.docID()));
                        }

                        public float matchCost() {
                            return 100.0f;
                        }
                    };
                    return new ConstantScoreScorer((Weight)this, this.score(), twoPhase);
                }
            };
        }
    }
}

