/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy.directory;

import java.io.IOException;
import org.apache.lucene.facet.taxonomy.ParallelTaxonomyArrays;
import org.apache.lucene.facet.taxonomy.directory.Consts;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;

class TaxonomyIndexArrays
extends ParallelTaxonomyArrays {
    private final int[] parents;
    private volatile boolean initializedChildren = false;
    private int[] children;
    private int[] siblings;

    private TaxonomyIndexArrays(int[] parents) {
        this.parents = parents;
    }

    public TaxonomyIndexArrays(IndexReader reader) throws IOException {
        this.parents = new int[reader.maxDoc()];
        if (this.parents.length > 0) {
            this.initParents(reader, 0);
            this.parents[0] = -1;
        }
    }

    public TaxonomyIndexArrays(IndexReader reader, TaxonomyIndexArrays copyFrom) throws IOException {
        assert (copyFrom != null);
        int[] copyParents = copyFrom.parents();
        this.parents = new int[reader.maxDoc()];
        System.arraycopy(copyParents, 0, this.parents, 0, copyParents.length);
        this.initParents(reader, copyParents.length);
        if (copyFrom.initializedChildren) {
            this.initChildrenSiblings(copyFrom);
        }
    }

    private final synchronized void initChildrenSiblings(TaxonomyIndexArrays copyFrom) {
        if (!this.initializedChildren) {
            this.children = new int[this.parents.length];
            this.siblings = new int[this.parents.length];
            if (copyFrom != null) {
                System.arraycopy(copyFrom.children(), 0, this.children, 0, copyFrom.children().length);
                System.arraycopy(copyFrom.siblings(), 0, this.siblings, 0, copyFrom.siblings().length);
                this.computeChildrenSiblings(copyFrom.parents.length);
            } else {
                this.computeChildrenSiblings(0);
            }
            this.initializedChildren = true;
        }
    }

    private void computeChildrenSiblings(int first) {
        int i;
        for (i = first; i < this.parents.length; ++i) {
            this.children[i] = -1;
        }
        if (first == 0) {
            first = 1;
            this.siblings[0] = -1;
        }
        for (i = first; i < this.parents.length; ++i) {
            this.siblings[i] = this.children[this.parents[i]];
            this.children[this.parents[i]] = i;
        }
    }

    private void initParents(IndexReader reader, int first) throws IOException {
        if (reader.maxDoc() == first) {
            return;
        }
        PostingsEnum positions = MultiFields.getTermPositionsEnum((IndexReader)reader, (String)"$payloads$", (BytesRef)Consts.PAYLOAD_PARENT_BYTES_REF, (int)88);
        if (positions == null || positions.advance(first) == Integer.MAX_VALUE) {
            throw new CorruptIndexException("Missing parent data for category " + first, reader.toString());
        }
        int num = reader.maxDoc();
        for (int i = first; i < num; ++i) {
            if (positions.docID() == i) {
                if (positions.freq() == 0) {
                    throw new CorruptIndexException("Missing parent data for category " + i, reader.toString());
                }
                this.parents[i] = positions.nextPosition();
                if (positions.nextDoc() != Integer.MAX_VALUE) continue;
                if (i + 1 >= num) break;
                throw new CorruptIndexException("Missing parent data for category " + (i + 1), reader.toString());
            }
            throw new CorruptIndexException("Missing parent data for category " + i, reader.toString());
        }
    }

    TaxonomyIndexArrays add(int ordinal, int parentOrdinal) {
        if (ordinal >= this.parents.length) {
            int[] newarray = ArrayUtil.grow((int[])this.parents, (int)(ordinal + 1));
            newarray[ordinal] = parentOrdinal;
            return new TaxonomyIndexArrays(newarray);
        }
        this.parents[ordinal] = parentOrdinal;
        return this;
    }

    @Override
    public int[] parents() {
        return this.parents;
    }

    @Override
    public int[] children() {
        if (!this.initializedChildren) {
            this.initChildrenSiblings(null);
        }
        return this.children;
    }

    @Override
    public int[] siblings() {
        if (!this.initializedChildren) {
            this.initChildrenSiblings(null);
        }
        return this.siblings;
    }
}

