/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.range;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.range.Range;
import org.apache.lucene.search.Query;

abstract class RangeFacetCounts
extends Facets {
    protected final Range[] ranges;
    protected final int[] counts;
    protected final Query fastMatchQuery;
    protected final String field;
    protected int totCount;

    protected RangeFacetCounts(String field, Range[] ranges, Query fastMatchQuery) throws IOException {
        this.field = field;
        this.ranges = ranges;
        this.fastMatchQuery = fastMatchQuery;
        this.counts = new int[ranges.length];
    }

    @Override
    public FacetResult getTopChildren(int topN, String dim, String ... path) {
        if (!dim.equals(this.field)) {
            throw new IllegalArgumentException("invalid dim \"" + dim + "\"; should be \"" + this.field + "\"");
        }
        if (path.length != 0) {
            throw new IllegalArgumentException("path.length should be 0");
        }
        LabelAndValue[] labelValues = new LabelAndValue[this.counts.length];
        for (int i = 0; i < this.counts.length; ++i) {
            labelValues[i] = new LabelAndValue(this.ranges[i].label, this.counts[i]);
        }
        return new FacetResult(dim, path, this.totCount, labelValues, labelValues.length);
    }

    @Override
    public Number getSpecificValue(String dim, String ... path) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<FacetResult> getAllDims(int topN) throws IOException {
        return Collections.singletonList(this.getTopChildren(topN, null, new String[0]));
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RangeFacetCounts totCount=");
        b.append(this.totCount);
        b.append(":\n");
        for (int i = 0; i < this.ranges.length; ++i) {
            b.append("  ");
            b.append(this.ranges[i].label);
            b.append(" -> count=");
            b.append(this.counts[i]);
            b.append('\n');
        }
        return b.toString();
    }
}

