/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy.directory;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.FacetLabel;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;
import org.apache.lucene.facet.taxonomy.directory.TaxonomyIndexArrays;
import org.apache.lucene.facet.taxonomy.writercache.Cl2oTaxonomyWriterCache;
import org.apache.lucene.facet.taxonomy.writercache.TaxonomyWriterCache;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.ReaderManager;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.TieredMergePolicy;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;

public class DirectoryTaxonomyWriter
implements TaxonomyWriter {
    public static final String INDEX_EPOCH = "index.epoch";
    private final Directory dir;
    private final IndexWriter indexWriter;
    private final TaxonomyWriterCache cache;
    private final AtomicInteger cacheMisses = new AtomicInteger(0);
    private long indexEpoch;
    private SinglePositionTokenStream parentStream = new SinglePositionTokenStream("p");
    private Field parentStreamField;
    private Field fullPathField;
    private int cacheMissesUntilFill = 11;
    private boolean shouldFillCache = true;
    private ReaderManager readerManager;
    private volatile boolean initializedReaderManager = false;
    private volatile boolean shouldRefreshReaderManager;
    private volatile boolean cacheIsComplete;
    private volatile boolean isClosed = false;
    private volatile TaxonomyIndexArrays taxoArrays;
    private volatile int nextID;

    private static Map<String, String> readCommitData(Directory dir) throws IOException {
        SegmentInfos infos = SegmentInfos.readLatestCommit((Directory)dir);
        return infos.getUserData();
    }

    public DirectoryTaxonomyWriter(Directory directory, IndexWriterConfig.OpenMode openMode, TaxonomyWriterCache cache) throws IOException {
        this.dir = directory;
        IndexWriterConfig config = this.createIndexWriterConfig(openMode);
        this.indexWriter = this.openIndexWriter(this.dir, config);
        assert (!(this.indexWriter.getConfig().getMergePolicy() instanceof TieredMergePolicy)) : "for preserving category docids, merging none-adjacent segments is not allowed";
        openMode = config.getOpenMode();
        if (!DirectoryReader.indexExists((Directory)directory)) {
            this.indexEpoch = 1L;
        } else {
            String epochStr = null;
            Map<String, String> commitData = DirectoryTaxonomyWriter.readCommitData(directory);
            if (commitData != null) {
                epochStr = commitData.get(INDEX_EPOCH);
            }
            long l = this.indexEpoch = epochStr == null ? 1L : Long.parseLong(epochStr, 16);
        }
        if (openMode == IndexWriterConfig.OpenMode.CREATE) {
            ++this.indexEpoch;
        }
        FieldType ft = new FieldType((IndexableFieldType)TextField.TYPE_NOT_STORED);
        ft.setOmitNorms(true);
        this.parentStreamField = new Field("$payloads$", (TokenStream)this.parentStream, (IndexableFieldType)ft);
        this.fullPathField = new StringField("$full_path$", "", Field.Store.YES);
        this.nextID = this.indexWriter.maxDoc();
        if (cache == null) {
            cache = DirectoryTaxonomyWriter.defaultTaxonomyWriterCache();
        }
        this.cache = cache;
        if (this.nextID == 0) {
            this.cacheIsComplete = true;
            this.addCategory(new FacetLabel(new String[0]));
        } else {
            this.cacheIsComplete = false;
        }
    }

    protected IndexWriter openIndexWriter(Directory directory, IndexWriterConfig config) throws IOException {
        return new IndexWriter(directory, config);
    }

    protected IndexWriterConfig createIndexWriterConfig(IndexWriterConfig.OpenMode openMode) {
        return new IndexWriterConfig(null).setOpenMode(openMode).setMergePolicy((MergePolicy)new LogByteSizeMergePolicy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initReaderManager() throws IOException {
        if (!this.initializedReaderManager) {
            DirectoryTaxonomyWriter directoryTaxonomyWriter = this;
            synchronized (directoryTaxonomyWriter) {
                this.ensureOpen();
                if (!this.initializedReaderManager) {
                    this.readerManager = new ReaderManager(this.indexWriter, false, false);
                    this.shouldRefreshReaderManager = false;
                    this.initializedReaderManager = true;
                }
            }
        }
    }

    public DirectoryTaxonomyWriter(Directory directory, IndexWriterConfig.OpenMode openMode) throws IOException {
        this(directory, openMode, DirectoryTaxonomyWriter.defaultTaxonomyWriterCache());
    }

    public static TaxonomyWriterCache defaultTaxonomyWriterCache() {
        return new Cl2oTaxonomyWriterCache(1024, 0.15f, 3);
    }

    public DirectoryTaxonomyWriter(Directory d) throws IOException {
        this(d, IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.isClosed) {
            this.commit();
            this.indexWriter.close();
            this.doClose();
        }
    }

    private void doClose() throws IOException {
        this.isClosed = true;
        this.closeResources();
    }

    protected synchronized void closeResources() throws IOException {
        if (this.initializedReaderManager) {
            this.readerManager.close();
            this.readerManager = null;
            this.initializedReaderManager = false;
        }
        if (this.cache != null) {
            this.cache.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized int findCategory(FacetLabel categoryPath) throws IOException {
        int res = this.cache.get(categoryPath);
        if (res >= 0 || this.cacheIsComplete) {
            return res;
        }
        this.cacheMisses.incrementAndGet();
        this.perhapsFillCache();
        res = this.cache.get(categoryPath);
        if (res >= 0 || this.cacheIsComplete) {
            return res;
        }
        this.initReaderManager();
        int doc = -1;
        DirectoryReader reader = (DirectoryReader)this.readerManager.acquire();
        try {
            BytesRef catTerm = new BytesRef((CharSequence)FacetsConfig.pathToString(categoryPath.components, categoryPath.length));
            PostingsEnum docs = null;
            for (LeafReaderContext ctx : reader.leaves()) {
                TermsEnum termsEnum;
                Terms terms = ctx.reader().terms("$full_path$");
                if (terms == null || !(termsEnum = terms.iterator()).seekExact(catTerm)) continue;
                docs = termsEnum.postings(docs, 0);
                doc = docs.nextDoc() + ctx.docBase;
                break;
            }
        }
        finally {
            this.readerManager.release((Object)reader);
        }
        if (doc > 0) {
            this.addToCache(categoryPath, doc);
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addCategory(FacetLabel categoryPath) throws IOException {
        this.ensureOpen();
        int res = this.cache.get(categoryPath);
        if (res < 0) {
            DirectoryTaxonomyWriter directoryTaxonomyWriter = this;
            synchronized (directoryTaxonomyWriter) {
                res = this.findCategory(categoryPath);
                if (res < 0) {
                    res = this.internalAddCategory(categoryPath);
                }
            }
        }
        return res;
    }

    private int internalAddCategory(FacetLabel cp) throws IOException {
        int parent;
        if (cp.length > 1) {
            FacetLabel parentPath = cp.subpath(cp.length - 1);
            parent = this.findCategory(parentPath);
            if (parent < 0) {
                parent = this.internalAddCategory(parentPath);
            }
        } else {
            parent = cp.length == 1 ? 0 : -1;
        }
        int id = this.addCategoryDocument(cp, parent);
        return id;
    }

    protected final void ensureOpen() {
        if (this.isClosed) {
            throw new AlreadyClosedException("The taxonomy writer has already been closed");
        }
    }

    private int addCategoryDocument(FacetLabel categoryPath, int parent) throws IOException {
        this.parentStream.set(Math.max(parent + 1, 1));
        Document d = new Document();
        d.add((IndexableField)this.parentStreamField);
        this.fullPathField.setStringValue(FacetsConfig.pathToString(categoryPath.components, categoryPath.length));
        d.add((IndexableField)this.fullPathField);
        this.indexWriter.addDocument((Iterable)d);
        int id = this.nextID++;
        this.shouldRefreshReaderManager = true;
        this.taxoArrays = this.getTaxoArrays().add(id, parent);
        this.addToCache(categoryPath, id);
        return id;
    }

    private void addToCache(FacetLabel categoryPath, int id) throws IOException {
        if (this.cache.put(categoryPath, id)) {
            this.refreshReaderManager();
            this.cacheIsComplete = false;
        }
    }

    private synchronized void refreshReaderManager() throws IOException {
        if (this.shouldRefreshReaderManager && this.initializedReaderManager) {
            this.readerManager.maybeRefresh();
            this.shouldRefreshReaderManager = false;
        }
    }

    public synchronized long commit() throws IOException {
        String epochStr;
        this.ensureOpen();
        HashMap data = new HashMap();
        Iterable iter = this.indexWriter.getLiveCommitData();
        if (iter != null) {
            for (Map.Entry ent : iter) {
                data.put(ent.getKey(), ent.getValue());
            }
        }
        if ((epochStr = (String)data.get(INDEX_EPOCH)) == null || Long.parseLong(epochStr, 16) != this.indexEpoch) {
            this.indexWriter.setLiveCommitData(this.combinedCommitData(this.indexWriter.getLiveCommitData()));
        }
        return this.indexWriter.commit();
    }

    private Iterable<Map.Entry<String, String>> combinedCommitData(Iterable<Map.Entry<String, String>> commitData) {
        HashMap<String, String> m = new HashMap<String, String>();
        if (commitData != null) {
            for (Map.Entry<String, String> ent : commitData) {
                m.put(ent.getKey(), ent.getValue());
            }
        }
        m.put(INDEX_EPOCH, Long.toString(this.indexEpoch, 16));
        return m.entrySet();
    }

    @Override
    public void setLiveCommitData(Iterable<Map.Entry<String, String>> commitUserData) {
        this.indexWriter.setLiveCommitData(this.combinedCommitData(commitUserData));
    }

    @Override
    public Iterable<Map.Entry<String, String>> getLiveCommitData() {
        return this.combinedCommitData(this.indexWriter.getLiveCommitData());
    }

    public synchronized long prepareCommit() throws IOException {
        String epochStr;
        this.ensureOpen();
        HashMap data = new HashMap();
        Iterable iter = this.indexWriter.getLiveCommitData();
        if (iter != null) {
            for (Map.Entry ent : iter) {
                data.put(ent.getKey(), ent.getValue());
            }
        }
        if ((epochStr = (String)data.get(INDEX_EPOCH)) == null || Long.parseLong(epochStr, 16) != this.indexEpoch) {
            this.indexWriter.setLiveCommitData(this.combinedCommitData(this.indexWriter.getLiveCommitData()));
        }
        return this.indexWriter.prepareCommit();
    }

    @Override
    public int getSize() {
        this.ensureOpen();
        return this.nextID;
    }

    public void setCacheMissesUntilFill(int i) {
        this.ensureOpen();
        this.cacheMissesUntilFill = i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void perhapsFillCache() throws IOException {
        if (this.cacheMisses.get() < this.cacheMissesUntilFill) {
            return;
        }
        if (!this.shouldFillCache) {
            return;
        }
        this.shouldFillCache = false;
        this.initReaderManager();
        boolean aborted = false;
        DirectoryReader reader = (DirectoryReader)this.readerManager.acquire();
        try {
            PostingsEnum postingsEnum = null;
            for (LeafReaderContext ctx : reader.leaves()) {
                Terms terms = ctx.reader().terms("$full_path$");
                if (terms != null) {
                    TermsEnum termsEnum = terms.iterator();
                    while (termsEnum.next() != null) {
                        if (!this.cache.isFull()) {
                            BytesRef t = termsEnum.term();
                            FacetLabel cp = new FacetLabel(FacetsConfig.stringToPath(t.utf8ToString()));
                            postingsEnum = termsEnum.postings(postingsEnum, 0);
                            boolean res = this.cache.put(cp, postingsEnum.nextDoc() + ctx.docBase);
                            assert (!res) : "entries should not have been evicted from the cache";
                            continue;
                        }
                        aborted = true;
                        break;
                    }
                }
                if (!aborted) continue;
                break;
            }
        }
        finally {
            this.readerManager.release((Object)reader);
        }
        boolean bl = this.cacheIsComplete = !aborted;
        if (this.cacheIsComplete) {
            DirectoryTaxonomyWriter directoryTaxonomyWriter = this;
            synchronized (directoryTaxonomyWriter) {
                this.readerManager.close();
                this.readerManager = null;
                this.initializedReaderManager = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaxonomyIndexArrays getTaxoArrays() throws IOException {
        if (this.taxoArrays == null) {
            DirectoryTaxonomyWriter directoryTaxonomyWriter = this;
            synchronized (directoryTaxonomyWriter) {
                if (this.taxoArrays == null) {
                    this.initReaderManager();
                    DirectoryReader reader = (DirectoryReader)this.readerManager.acquire();
                    try {
                        TaxonomyIndexArrays tmpArrays;
                        this.taxoArrays = tmpArrays = new TaxonomyIndexArrays((IndexReader)reader);
                    }
                    finally {
                        this.readerManager.release((Object)reader);
                    }
                }
            }
        }
        return this.taxoArrays;
    }

    @Override
    public int getParent(int ordinal) throws IOException {
        this.ensureOpen();
        if (ordinal >= this.nextID) {
            throw new ArrayIndexOutOfBoundsException("requested ordinal is bigger than the largest ordinal in the taxonomy");
        }
        int[] parents = this.getTaxoArrays().parents();
        assert (ordinal < parents.length) : "requested ordinal (" + ordinal + "); parents.length (" + parents.length + ") !";
        return parents[ordinal];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaxonomy(Directory taxoDir, OrdinalMap map) throws IOException {
        this.ensureOpen();
        try (DirectoryReader r = DirectoryReader.open((Directory)taxoDir);){
            int size = r.numDocs();
            OrdinalMap ordinalMap = map;
            ordinalMap.setSize(size);
            int base = 0;
            PostingsEnum docs = null;
            for (LeafReaderContext ctx : r.leaves()) {
                LeafReader ar = ctx.reader();
                Terms terms = ar.terms("$full_path$");
                TermsEnum te = terms.iterator();
                while (te.next() != null) {
                    FacetLabel cp = new FacetLabel(FacetsConfig.stringToPath(te.term().utf8ToString()));
                    int ordinal = this.addCategory(cp);
                    docs = te.postings(docs, 0);
                    ordinalMap.addMapping(docs.nextDoc() + base, ordinal);
                }
                base += ar.maxDoc();
            }
            ordinalMap.addDone();
        }
    }

    public synchronized void rollback() throws IOException {
        this.ensureOpen();
        this.indexWriter.rollback();
        this.doClose();
    }

    public synchronized void replaceTaxonomy(Directory taxoDir) throws IOException {
        this.indexWriter.deleteAll();
        this.indexWriter.addIndexes(new Directory[]{taxoDir});
        this.shouldRefreshReaderManager = true;
        this.initReaderManager();
        this.refreshReaderManager();
        this.nextID = this.indexWriter.maxDoc();
        this.taxoArrays = null;
        this.cache.clear();
        this.cacheIsComplete = false;
        this.shouldFillCache = true;
        this.cacheMisses.set(0);
        ++this.indexEpoch;
    }

    public Directory getDirectory() {
        return this.dir;
    }

    final IndexWriter getInternalIndexWriter() {
        return this.indexWriter;
    }

    public final long getTaxonomyEpoch() {
        return this.indexEpoch;
    }

    public static final class DiskOrdinalMap
    implements OrdinalMap {
        Path tmpfile;
        DataOutputStream out;
        int[] map = null;

        public DiskOrdinalMap(Path tmpfile) throws IOException {
            this.tmpfile = tmpfile;
            this.out = new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(tmpfile, new OpenOption[0])));
        }

        @Override
        public void addMapping(int origOrdinal, int newOrdinal) throws IOException {
            this.out.writeInt(origOrdinal);
            this.out.writeInt(newOrdinal);
        }

        @Override
        public void setSize(int taxonomySize) throws IOException {
            this.out.writeInt(taxonomySize);
        }

        @Override
        public void addDone() throws IOException {
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
        }

        @Override
        public int[] getMap() throws IOException {
            if (this.map != null) {
                return this.map;
            }
            this.addDone();
            try (DataInputStream in = new DataInputStream(new BufferedInputStream(Files.newInputStream(this.tmpfile, new OpenOption[0])));){
                this.map = new int[in.readInt()];
                for (int i = 0; i < this.map.length; ++i) {
                    int newordinal;
                    int origordinal = in.readInt();
                    this.map[origordinal] = newordinal = in.readInt();
                }
            }
            Files.delete(this.tmpfile);
            return this.map;
        }
    }

    public static final class MemoryOrdinalMap
    implements OrdinalMap {
        int[] map;

        @Override
        public void setSize(int taxonomySize) {
            this.map = new int[taxonomySize];
        }

        @Override
        public void addMapping(int origOrdinal, int newOrdinal) {
            this.map[origOrdinal] = newOrdinal;
        }

        @Override
        public void addDone() {
        }

        @Override
        public int[] getMap() {
            return this.map;
        }
    }

    public static interface OrdinalMap {
        public void setSize(int var1) throws IOException;

        public void addMapping(int var1, int var2) throws IOException;

        public void addDone() throws IOException;

        public int[] getMap() throws IOException;
    }

    private static class SinglePositionTokenStream
    extends TokenStream {
        private CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        private PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
        private boolean returned;
        private int val;
        private final String word;

        public SinglePositionTokenStream(String word) {
            this.word = word;
            this.returned = true;
        }

        public void set(int val) {
            this.val = val;
            this.returned = false;
        }

        public boolean incrementToken() throws IOException {
            if (this.returned) {
                return false;
            }
            this.clearAttributes();
            this.posIncrAtt.setPositionIncrement(this.val);
            this.termAtt.setEmpty();
            this.termAtt.append(this.word);
            this.returned = true;
            return true;
        }
    }
}

