/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import java.io.IOException;
import org.apache.lucene.facet.taxonomy.DocValuesOrdinalsReader;
import org.apache.lucene.facet.taxonomy.FacetLabel;
import org.apache.lucene.facet.taxonomy.OrdinalsReader;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.IntsRef;

public class TaxonomyFacetLabels {
    private final String indexFieldName;
    private final TaxonomyReader taxoReader;
    private final OrdinalsReader ordsReader;

    public TaxonomyFacetLabels(TaxonomyReader taxoReader, String indexFieldName) throws IOException {
        this.taxoReader = taxoReader;
        this.indexFieldName = indexFieldName;
        this.ordsReader = new DocValuesOrdinalsReader(indexFieldName);
    }

    public FacetLabelReader getFacetLabelReader(LeafReaderContext readerContext) throws IOException {
        return new FacetLabelReader(this.ordsReader, readerContext);
    }

    public class FacetLabelReader {
        private final OrdinalsReader.OrdinalsSegmentReader ordinalsSegmentReader;
        private final IntsRef decodedOrds = new IntsRef();
        private int currentDocId = -1;
        private int currentPos = -1;
        private int[] parents;

        public FacetLabelReader(OrdinalsReader ordsReader, LeafReaderContext readerContext) throws IOException {
            this.ordinalsSegmentReader = ordsReader.getReader(readerContext);
        }

        public FacetLabel nextFacetLabel(int docId) throws IOException {
            if (this.currentDocId != docId) {
                if (docId < this.currentDocId) {
                    throw new IllegalArgumentException("docs out of order: previous docId=" + this.currentDocId + " current docId=" + docId);
                }
                this.ordinalsSegmentReader.get(docId, this.decodedOrds);
                this.currentDocId = docId;
                this.currentPos = this.decodedOrds.offset;
            }
            int endPos = this.decodedOrds.offset + this.decodedOrds.length;
            assert (this.currentPos <= endPos);
            if (this.currentPos == endPos) {
                return null;
            }
            int ord = this.decodedOrds.ints[this.currentPos++];
            return TaxonomyFacetLabels.this.taxoReader.getPath(ord);
        }

        private boolean isDescendant(int ord, int ancestorOrd) {
            while (ord != -1 && ord != 0) {
                if (this.parents[ord] == ancestorOrd) {
                    return true;
                }
                ord = this.parents[ord];
            }
            return false;
        }

        public FacetLabel nextFacetLabel(int docId, String facetDimension) throws IOException {
            if (facetDimension == null) {
                throw new IllegalArgumentException("Input facet dimension cannot be null");
            }
            int parentOrd = TaxonomyFacetLabels.this.taxoReader.getOrdinal(new FacetLabel(facetDimension));
            if (parentOrd == -1) {
                throw new IllegalArgumentException("Category ordinal not found for facet dimension: " + facetDimension);
            }
            if (this.currentDocId != docId) {
                if (docId < this.currentDocId) {
                    throw new IllegalArgumentException("docs out of order: previous docId=" + this.currentDocId + " current docId=" + docId);
                }
                this.ordinalsSegmentReader.get(docId, this.decodedOrds);
                this.currentPos = this.decodedOrds.offset;
                this.currentDocId = docId;
            }
            if (this.parents == null) {
                this.parents = TaxonomyFacetLabels.this.taxoReader.getParallelTaxonomyArrays().parents();
            }
            int endPos = this.decodedOrds.offset + this.decodedOrds.length;
            assert (this.currentPos <= endPos);
            while (this.currentPos < endPos) {
                int ord;
                if (!this.isDescendant(ord = this.decodedOrds.ints[this.currentPos++], parentOrd)) continue;
                return TaxonomyFacetLabels.this.taxoReader.getPath(ord);
            }
            return null;
        }
    }
}

