/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.range;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.range.LongRange;
import org.apache.lucene.facet.range.LongRangeCounter;
import org.apache.lucene.facet.range.RangeFacetCounts;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LongValues;
import org.apache.lucene.search.LongValuesSource;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public class LongRangeFacetCounts
extends RangeFacetCounts {
    public LongRangeFacetCounts(String field, FacetsCollector hits, LongRange ... ranges) throws IOException {
        this(field, LongValuesSource.fromLongField((String)field), hits, ranges);
    }

    public LongRangeFacetCounts(String field, LongValuesSource valueSource, FacetsCollector hits, LongRange ... ranges) throws IOException {
        this(field, valueSource, hits, (Query)null, ranges);
    }

    public LongRangeFacetCounts(String field, LongValuesSource valueSource, FacetsCollector hits, Query fastMatchQuery, LongRange ... ranges) throws IOException {
        super(field, ranges, fastMatchQuery);
        this.count(valueSource, hits.getMatchingDocs());
    }

    private void count(LongValuesSource valueSource, List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        LongRange[] ranges = (LongRange[])this.ranges;
        LongRangeCounter counter = new LongRangeCounter(ranges);
        int missingCount = 0;
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            DocIdSetIterator fastMatchDocs;
            LongValues fv = valueSource.getValues(hits.context, null);
            this.totCount += hits.totalHits;
            if (this.fastMatchQuery != null) {
                IndexReaderContext topLevelContext = ReaderUtil.getTopLevelContext((IndexReaderContext)hits.context);
                IndexSearcher searcher = new IndexSearcher(topLevelContext);
                searcher.setQueryCache(null);
                Weight fastMatchWeight = searcher.createWeight(searcher.rewrite(this.fastMatchQuery), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
                Scorer s = fastMatchWeight.scorer(hits.context);
                if (s == null) continue;
                fastMatchDocs = s.iterator();
            } else {
                fastMatchDocs = null;
            }
            DocIdSetIterator docs = hits.bits.iterator();
            int doc = docs.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                if (fastMatchDocs != null) {
                    int fastMatchDoc = fastMatchDocs.docID();
                    if (fastMatchDoc < doc) {
                        fastMatchDoc = fastMatchDocs.advance(doc);
                    }
                    if (doc != fastMatchDoc) {
                        doc = docs.advance(fastMatchDoc);
                        continue;
                    }
                }
                if (fv.advanceExact(doc)) {
                    counter.add(fv.longValue());
                } else {
                    ++missingCount;
                }
                doc = docs.nextDoc();
            }
        }
        int x = counter.fillCounts(this.counts);
        this.totCount -= (missingCount += x);
    }
}

