/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.TopOrdAndFloatQueue;
import org.apache.lucene.facet.taxonomy.FacetLabel;
import org.apache.lucene.facet.taxonomy.TaxonomyFacets;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;

@Deprecated
public abstract class FloatTaxonomyFacets
extends TaxonomyFacets {
    protected final float[] values;

    protected FloatTaxonomyFacets(String indexFieldName, TaxonomyReader taxoReader, FacetsConfig config) throws IOException {
        super(indexFieldName, taxoReader, config);
        this.values = new float[taxoReader.getSize()];
    }

    protected void rollup() throws IOException {
        int[] children = this.getChildren();
        for (Map.Entry<String, FacetsConfig.DimConfig> ent : this.config.getDimConfigs().entrySet()) {
            String dim = ent.getKey();
            FacetsConfig.DimConfig ft = ent.getValue();
            if (!ft.hierarchical || ft.multiValued) continue;
            int dimRootOrd = this.taxoReader.getOrdinal(new FacetLabel(dim));
            assert (dimRootOrd > 0);
            int n = dimRootOrd;
            this.values[n] = this.values[n] + this.rollup(children[dimRootOrd]);
        }
    }

    private float rollup(int ord) throws IOException {
        int[] children = this.getChildren();
        int[] siblings = this.getSiblings();
        float sum = 0.0f;
        while (ord != -1) {
            float childValue;
            this.values[ord] = childValue = this.values[ord] + this.rollup(children[ord]);
            sum += childValue;
            ord = siblings[ord];
        }
        return sum;
    }

    @Override
    public Number getSpecificValue(String dim, String ... path) throws IOException {
        FacetsConfig.DimConfig dimConfig = this.verifyDim(dim);
        if (!(path.length != 0 || dimConfig.hierarchical && !dimConfig.multiValued || dimConfig.requireDimCount && dimConfig.multiValued)) {
            throw new IllegalArgumentException("cannot return dimension-level value alone; use getTopChildren instead");
        }
        int ord = this.taxoReader.getOrdinal(new FacetLabel(dim, path));
        if (ord < 0) {
            return -1;
        }
        return Float.valueOf(this.values[ord]);
    }

    @Override
    public FacetResult getTopChildren(int topN, String dim, String ... path) throws IOException {
        if (topN <= 0) {
            throw new IllegalArgumentException("topN must be > 0 (got: " + topN + ")");
        }
        FacetsConfig.DimConfig dimConfig = this.verifyDim(dim);
        FacetLabel cp = new FacetLabel(dim, path);
        int dimOrd = this.taxoReader.getOrdinal(cp);
        if (dimOrd == -1) {
            return null;
        }
        TopOrdAndFloatQueue q = new TopOrdAndFloatQueue(Math.min(this.taxoReader.getSize(), topN));
        float bottomValue = 0.0f;
        int[] children = this.getChildren();
        int[] siblings = this.getSiblings();
        int ord = children[dimOrd];
        float sumValues = 0.0f;
        int childCount = 0;
        TopOrdAndFloatQueue.OrdAndValue reuse = null;
        while (ord != -1) {
            if (this.values[ord] > 0.0f) {
                sumValues += this.values[ord];
                ++childCount;
                if (this.values[ord] > bottomValue) {
                    if (reuse == null) {
                        reuse = new TopOrdAndFloatQueue.OrdAndValue();
                    }
                    reuse.ord = ord;
                    reuse.value = this.values[ord];
                    reuse = (TopOrdAndFloatQueue.OrdAndValue)q.insertWithOverflow(reuse);
                    if (q.size() == topN) {
                        bottomValue = ((TopOrdAndFloatQueue.OrdAndValue)q.top()).value;
                    }
                }
            }
            ord = siblings[ord];
        }
        if (sumValues == 0.0f) {
            return null;
        }
        if (dimConfig.multiValued) {
            sumValues = dimConfig.requireDimCount ? this.values[dimOrd] : -1.0f;
        }
        LabelAndValue[] labelValues = new LabelAndValue[q.size()];
        int[] ordinals = new int[labelValues.length];
        float[] values = new float[labelValues.length];
        for (int i = labelValues.length - 1; i >= 0; --i) {
            TopOrdAndFloatQueue.OrdAndValue ordAndValue = (TopOrdAndFloatQueue.OrdAndValue)q.pop();
            ordinals[i] = ordAndValue.ord;
            values[i] = ordAndValue.value;
        }
        FacetLabel[] bulkPath = this.taxoReader.getBulkPath(ordinals);
        for (int i = 0; i < labelValues.length; ++i) {
            labelValues[i] = new LabelAndValue(bulkPath[i].components[cp.length], Float.valueOf(values[i]));
        }
        return new FacetResult(dim, path, Float.valueOf(sumValues), labelValues, childCount);
    }
}

