/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.ParallelTaxonomyArrays;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;

@Deprecated
public abstract class TaxonomyFacets
extends Facets {
    private static final Comparator<FacetResult> BY_VALUE_THEN_DIM = new Comparator<FacetResult>(){

        @Override
        public int compare(FacetResult a, FacetResult b) {
            if (a.value.doubleValue() > b.value.doubleValue()) {
                return -1;
            }
            if (b.value.doubleValue() > a.value.doubleValue()) {
                return 1;
            }
            return a.dim.compareTo(b.dim);
        }
    };
    protected final String indexFieldName;
    protected final TaxonomyReader taxoReader;
    protected final FacetsConfig config;
    private ParallelTaxonomyArrays.IntArray children;
    private ParallelTaxonomyArrays.IntArray siblings;
    final ParallelTaxonomyArrays.IntArray parents;

    protected TaxonomyFacets(String indexFieldName, TaxonomyReader taxoReader, FacetsConfig config) throws IOException {
        this.indexFieldName = indexFieldName;
        this.taxoReader = taxoReader;
        this.config = config;
        this.parents = taxoReader.getParallelTaxonomyArrays().parents();
    }

    ParallelTaxonomyArrays.IntArray getChildren() throws IOException {
        if (this.children == null) {
            this.children = this.taxoReader.getParallelTaxonomyArrays().children();
        }
        return this.children;
    }

    ParallelTaxonomyArrays.IntArray getSiblings() throws IOException {
        if (this.siblings == null) {
            this.siblings = this.taxoReader.getParallelTaxonomyArrays().siblings();
        }
        return this.siblings;
    }

    public boolean childrenLoaded() {
        return this.children != null;
    }

    public boolean siblingsLoaded() {
        return this.siblings != null;
    }

    protected FacetsConfig.DimConfig verifyDim(String dim) {
        FacetsConfig.DimConfig dimConfig = this.config.getDimConfig(dim);
        if (this.config.isDimConfigured(dim) && !dimConfig.indexFieldName.equals(this.indexFieldName)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "dimension \"%s\" cannot be found in field \"%s\", since it was configured to be indexed into field \"%s\"", dim, this.indexFieldName, dimConfig.indexFieldName));
        }
        return dimConfig;
    }

    @Override
    public List<FacetResult> getAllDims(int topN) throws IOException {
        TaxonomyFacets.validateTopN(topN);
        ParallelTaxonomyArrays.IntArray children = this.getChildren();
        ParallelTaxonomyArrays.IntArray siblings = this.getSiblings();
        int ord = children.get(0);
        ArrayList<FacetResult> results = new ArrayList<FacetResult>();
        while (ord != -1) {
            FacetResult result;
            String dim = this.taxoReader.getPath((int)ord).components[0];
            FacetsConfig.DimConfig dimConfig = this.config.getDimConfig(dim);
            if (dimConfig.indexFieldName.equals(this.indexFieldName) && (result = this.getTopChildren(topN, dim, new String[0])) != null) {
                results.add(result);
            }
            ord = siblings.get(ord);
        }
        results.sort(BY_VALUE_THEN_DIM);
        return results;
    }
}

