/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping.dv;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.search.grouping.AbstractDistinctValuesCollector;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SentinelIntSet;

public abstract class DVDistinctValuesCollector<GC extends AbstractDistinctValuesCollector.GroupCount<?>>
extends AbstractDistinctValuesCollector<GC> {
    final String groupField;
    final String countField;
    final boolean diskResident;
    final DocValues.Type valueType;

    DVDistinctValuesCollector(String groupField, String countField, boolean diskResident, DocValues.Type valueType) {
        this.groupField = groupField;
        this.countField = countField;
        this.diskResident = diskResident;
        this.valueType = valueType;
    }

    public static <T> DVDistinctValuesCollector<AbstractDistinctValuesCollector.GroupCount<T>> create(String groupField, String countField, Collection<SearchGroup<T>> groups, boolean diskResident, DocValues.Type type) {
        switch (type) {
            case VAR_INTS: 
            case FIXED_INTS_8: 
            case FIXED_INTS_16: 
            case FIXED_INTS_32: 
            case FIXED_INTS_64: {
                return new NonSorted.Lng(groupField, countField, groups, diskResident, type);
            }
            case FLOAT_32: 
            case FLOAT_64: {
                return new NonSorted.Dbl(groupField, countField, groups, diskResident, type);
            }
            case BYTES_FIXED_STRAIGHT: 
            case BYTES_FIXED_DEREF: 
            case BYTES_VAR_STRAIGHT: 
            case BYTES_VAR_DEREF: {
                return new NonSorted.BR(groupField, countField, groups, diskResident, type);
            }
            case BYTES_VAR_SORTED: 
            case BYTES_FIXED_SORTED: {
                return new Sorted.BR(groupField, countField, groups, diskResident, type);
            }
        }
        throw new IllegalArgumentException(String.format("ValueType %s not supported", type));
    }

    static abstract class Sorted
    extends DVDistinctValuesCollector<GroupCount> {
        final SentinelIntSet ordSet;
        final GroupCount[] groupCounts;
        final List<GroupCount> groups = new ArrayList<GroupCount>();
        DocValues.SortedSource groupFieldSource;
        DocValues.SortedSource countFieldSource;

        Sorted(String groupField, String countField, int groupSize, boolean diskResident, DocValues.Type valueType) {
            super(groupField, countField, diskResident, valueType);
            this.ordSet = new SentinelIntSet(groupSize, -1);
            this.groupCounts = new GroupCount[this.ordSet.keys.length];
        }

        @Override
        public List<GroupCount> getGroups() {
            return this.groups;
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.groupFieldSource = this.retrieveSortedSource(this.groupField, context);
            this.countFieldSource = this.retrieveSortedSource(this.countField, context);
            this.ordSet.clear();
        }

        private DocValues.SortedSource retrieveSortedSource(String field, AtomicReaderContext context) throws IOException {
            DocValues countFieldDv = context.reader().docValues(field);
            if (countFieldDv != null) {
                return this.diskResident ? countFieldDv.getDirectSource().asSortedSource() : countFieldDv.getSource().asSortedSource();
            }
            return DocValues.getDefaultSortedSource((DocValues.Type)this.valueType, (int)context.reader().maxDoc());
        }

        static class GroupCount
        extends AbstractDistinctValuesCollector.GroupCount<Comparable<?>> {
            int[] ords;

            GroupCount(Comparable<?> groupValue) {
                super(groupValue);
            }
        }

        static class BR
        extends Sorted {
            final BytesRef spare = new BytesRef();

            BR(String groupField, String countField, Collection<SearchGroup<BytesRef>> searchGroups, boolean diskResident, DocValues.Type valueType) {
                super(groupField, countField, searchGroups.size(), diskResident, valueType);
                for (SearchGroup<BytesRef> group : searchGroups) {
                    this.groups.add(new GroupCount((Comparable)group.groupValue));
                }
            }

            public void collect(int doc) throws IOException {
                int slot = this.ordSet.find(this.groupFieldSource.ord(doc));
                if (slot < 0) {
                    return;
                }
                GroupCount gc = this.groupCounts[slot];
                int countOrd = this.countFieldSource.ord(doc);
                if (this.doesNotContainsOrd(countOrd, gc.ords)) {
                    gc.uniqueValues.add(this.countFieldSource.getByOrd(countOrd, new BytesRef()));
                    gc.ords = Arrays.copyOf(gc.ords, gc.ords.length + 1);
                    gc.ords[gc.ords.length - 1] = countOrd;
                    if (gc.ords.length > 1) {
                        Arrays.sort(gc.ords);
                    }
                }
            }

            private boolean doesNotContainsOrd(int ord, int[] ords) {
                if (ords.length == 0) {
                    return true;
                }
                if (ords.length == 1) {
                    return ord != ords[0];
                }
                return Arrays.binarySearch(ords, ord) < 0;
            }

            @Override
            public void setNextReader(AtomicReaderContext context) throws IOException {
                super.setNextReader(context);
                for (GroupCount group : this.groups) {
                    int groupOrd = this.groupFieldSource.getOrdByValue((BytesRef)group.groupValue, this.spare);
                    if (groupOrd < 0) continue;
                    this.groupCounts[this.ordSet.put((int)groupOrd)] = group;
                    group.ords = new int[group.uniqueValues.size()];
                    Arrays.fill(group.ords, -1);
                    int i = 0;
                    for (Comparable value : group.uniqueValues) {
                        int countOrd = this.countFieldSource.getOrdByValue((BytesRef)value, this.spare);
                        if (countOrd < 0) continue;
                        group.ords[i++] = countOrd;
                    }
                }
            }
        }
    }

    static abstract class NonSorted<K>
    extends DVDistinctValuesCollector<GroupCount> {
        final Map<K, GroupCount> groupMap = new LinkedHashMap<K, GroupCount>();
        DocValues.Source groupFieldSource;
        DocValues.Source countFieldSource;

        NonSorted(String groupField, String countField, boolean diskResident, DocValues.Type valueType) {
            super(groupField, countField, diskResident, valueType);
        }

        @Override
        public List<GroupCount> getGroups() {
            return new ArrayList<GroupCount>(this.groupMap.values());
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.groupFieldSource = this.retrieveSource(this.groupField, context);
            this.countFieldSource = this.retrieveSource(this.countField, context);
        }

        private DocValues.Source retrieveSource(String fieldName, AtomicReaderContext context) throws IOException {
            DocValues groupFieldDv = context.reader().docValues(fieldName);
            if (groupFieldDv != null) {
                return this.diskResident ? groupFieldDv.getDirectSource() : groupFieldDv.getSource();
            }
            return DocValues.getDefaultSource((DocValues.Type)this.valueType);
        }

        static class GroupCount
        extends AbstractDistinctValuesCollector.GroupCount<Comparable<?>> {
            GroupCount(Comparable<?> groupValue) {
                super(groupValue);
            }
        }

        static class BR
        extends NonSorted<BytesRef> {
            private final BytesRef spare = new BytesRef();

            BR(String groupField, String countField, Collection<SearchGroup<BytesRef>> groups, boolean diskResident, DocValues.Type valueType) {
                super(groupField, countField, diskResident, valueType);
                for (SearchGroup<BytesRef> group : groups) {
                    this.groupMap.put(group.groupValue, new GroupCount((Comparable)group.groupValue));
                }
            }

            public void collect(int doc) throws IOException {
                BytesRef countValue;
                GroupCount groupCount = (GroupCount)this.groupMap.get(this.groupFieldSource.getBytes(doc, this.spare));
                if (groupCount != null && !groupCount.uniqueValues.contains(countValue = this.countFieldSource.getBytes(doc, this.spare))) {
                    groupCount.uniqueValues.add(BytesRef.deepCopyOf((BytesRef)countValue));
                }
            }
        }

        static class Lng
        extends NonSorted<Long> {
            Lng(String groupField, String countField, Collection<SearchGroup<Long>> groups, boolean diskResident, DocValues.Type valueType) {
                super(groupField, countField, diskResident, valueType);
                for (SearchGroup<Long> group : groups) {
                    this.groupMap.put(group.groupValue, new GroupCount((Comparable)group.groupValue));
                }
            }

            public void collect(int doc) throws IOException {
                GroupCount groupCount = (GroupCount)this.groupMap.get(this.groupFieldSource.getInt(doc));
                if (groupCount != null) {
                    groupCount.uniqueValues.add(this.countFieldSource.getInt(doc));
                }
            }
        }

        static class Dbl
        extends NonSorted<Double> {
            Dbl(String groupField, String countField, Collection<SearchGroup<Double>> groups, boolean diskResident, DocValues.Type valueType) {
                super(groupField, countField, diskResident, valueType);
                for (SearchGroup<Double> group : groups) {
                    this.groupMap.put(group.groupValue, new GroupCount((Comparable)group.groupValue));
                }
            }

            public void collect(int doc) throws IOException {
                GroupCount groupCount = (GroupCount)this.groupMap.get(this.groupFieldSource.getFloat(doc));
                if (groupCount != null) {
                    groupCount.uniqueValues.add(this.countFieldSource.getFloat(doc));
                }
            }
        }
    }
}

