/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping.function;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.grouping.AbstractDistinctValuesCollector;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.util.mutable.MutableValue;

public class FunctionDistinctValuesCollector
extends AbstractDistinctValuesCollector<GroupCount> {
    private final Map<?, ?> vsContext;
    private final ValueSource groupSource;
    private final ValueSource countSource;
    private final Map<MutableValue, GroupCount> groupMap;
    private FunctionValues.ValueFiller groupFiller;
    private FunctionValues.ValueFiller countFiller;
    private MutableValue groupMval;
    private MutableValue countMval;

    public FunctionDistinctValuesCollector(Map<?, ?> vsContext, ValueSource groupSource, ValueSource countSource, Collection<SearchGroup<MutableValue>> groups) {
        this.vsContext = vsContext;
        this.groupSource = groupSource;
        this.countSource = countSource;
        this.groupMap = new LinkedHashMap<MutableValue, GroupCount>();
        for (SearchGroup<MutableValue> group : groups) {
            this.groupMap.put((MutableValue)group.groupValue, new GroupCount((MutableValue)group.groupValue));
        }
    }

    @Override
    public List<GroupCount> getGroups() {
        return new ArrayList<GroupCount>(this.groupMap.values());
    }

    public void collect(int doc) throws IOException {
        this.groupFiller.fillValue(doc);
        GroupCount groupCount = this.groupMap.get(this.groupMval);
        if (groupCount != null) {
            this.countFiller.fillValue(doc);
            groupCount.uniqueValues.add(this.countMval.duplicate());
        }
    }

    public void setNextReader(AtomicReaderContext context) throws IOException {
        FunctionValues values = this.groupSource.getValues(this.vsContext, context);
        this.groupFiller = values.getValueFiller();
        this.groupMval = this.groupFiller.getValue();
        values = this.countSource.getValues(this.vsContext, context);
        this.countFiller = values.getValueFiller();
        this.countMval = this.countFiller.getValue();
    }

    public static class GroupCount
    extends AbstractDistinctValuesCollector.GroupCount<MutableValue> {
        GroupCount(MutableValue groupValue) {
            super(groupValue);
        }
    }
}

