/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.postingshighlight;

import org.apache.lucene.index.Term;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.SorterTemplate;

public final class Passage {
    int startOffset = -1;
    int endOffset = -1;
    float score = 0.0f;
    int[] matchStarts = new int[8];
    int[] matchEnds = new int[8];
    Term[] matchTerms = new Term[8];
    int numMatches = 0;

    void addMatch(int startOffset, int endOffset, Term term) {
        assert (startOffset >= this.startOffset && startOffset <= this.endOffset);
        if (this.numMatches == this.matchStarts.length) {
            this.matchStarts = ArrayUtil.grow((int[])this.matchStarts, (int)(this.numMatches + 1));
            this.matchEnds = ArrayUtil.grow((int[])this.matchEnds, (int)(this.numMatches + 1));
            Term[] newMatchTerms = new Term[ArrayUtil.oversize((int)(this.numMatches + 1), (int)RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            System.arraycopy(this.matchTerms, 0, newMatchTerms, 0, this.numMatches);
            this.matchTerms = newMatchTerms;
        }
        this.matchStarts[this.numMatches] = startOffset;
        this.matchEnds[this.numMatches] = endOffset;
        this.matchTerms[this.numMatches] = term;
        ++this.numMatches;
    }

    void sort() {
        final int[] starts = this.matchStarts;
        final int[] ends = this.matchEnds;
        final Term[] terms = this.matchTerms;
        new SorterTemplate(){
            int pivot;

            protected void swap(int i, int j) {
                int temp = starts[i];
                starts[i] = starts[j];
                starts[j] = temp;
                temp = ends[i];
                ends[i] = ends[j];
                ends[j] = temp;
                Term tempTerm = terms[i];
                terms[i] = terms[j];
                terms[j] = tempTerm;
            }

            protected int compare(int i, int j) {
                return Long.signum((long)starts[i] - (long)starts[j]);
            }

            protected void setPivot(int i) {
                this.pivot = starts[i];
            }

            protected int comparePivot(int j) {
                return Long.signum((long)this.pivot - (long)starts[j]);
            }
        }.mergeSort(0, this.numMatches - 1);
    }

    void reset() {
        this.endOffset = -1;
        this.startOffset = -1;
        this.score = 0.0f;
        this.numMatches = 0;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public float getScore() {
        return this.score;
    }

    public int getNumMatches() {
        return this.numMatches;
    }

    public int[] getMatchStarts() {
        return this.matchStarts;
    }

    public int[] getMatchEnds() {
        return this.matchEnds;
    }

    public Term[] getMatchTerms() {
        return this.matchTerms;
    }
}

