/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.postingshighlight;

import org.apache.lucene.search.postingshighlight.Passage;

public class PassageFormatter {
    private final String preTag;
    private final String postTag;
    private final String ellipsis;

    public PassageFormatter() {
        this("<b>", "</b>", "... ");
    }

    public PassageFormatter(String preTag, String postTag, String ellipsis) {
        if (preTag == null || postTag == null || ellipsis == null) {
            throw new NullPointerException();
        }
        this.preTag = preTag;
        this.postTag = postTag;
        this.ellipsis = ellipsis;
    }

    public String format(Passage[] passages, String content) {
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        for (Passage passage : passages) {
            if (passage.startOffset > pos && pos > 0) {
                sb.append(this.ellipsis);
            }
            pos = passage.startOffset;
            for (int i = 0; i < passage.numMatches; ++i) {
                int start = passage.matchStarts[i];
                int end = passage.matchEnds[i];
                if (start > pos) {
                    sb.append(content.substring(pos, start));
                }
                if (end <= pos) continue;
                sb.append(this.preTag);
                sb.append(content.substring(Math.max(pos, start), end));
                sb.append(this.postTag);
                pos = end;
            }
            sb.append(content.substring(pos, Math.max(pos, passage.endOffset)));
            pos = passage.endOffset;
        }
        return sb.toString();
    }
}

