/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;

public class ToParentBlockJoinQuery
extends Query {
    private final Filter parentsFilter;
    private final Query childQuery;
    private final Query origChildQuery;
    private final ScoreMode scoreMode;

    public ToParentBlockJoinQuery(Query childQuery, Filter parentsFilter, ScoreMode scoreMode) {
        this.origChildQuery = childQuery;
        this.childQuery = childQuery;
        this.parentsFilter = parentsFilter;
        this.scoreMode = scoreMode;
    }

    private ToParentBlockJoinQuery(Query origChildQuery, Query childQuery, Filter parentsFilter, ScoreMode scoreMode) {
        this.origChildQuery = origChildQuery;
        this.childQuery = childQuery;
        this.parentsFilter = parentsFilter;
        this.scoreMode = scoreMode;
    }

    public Weight createWeight(IndexSearcher searcher) throws IOException {
        return new BlockJoinWeight(this, this.childQuery.createWeight(searcher), this.parentsFilter, this.scoreMode);
    }

    public void extractTerms(Set<Term> terms) {
        this.childQuery.extractTerms(terms);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query childRewrite = this.childQuery.rewrite(reader);
        if (childRewrite != this.childQuery) {
            ToParentBlockJoinQuery rewritten = new ToParentBlockJoinQuery(this.childQuery, childRewrite, this.parentsFilter, this.scoreMode);
            rewritten.setBoost(this.getBoost());
            return rewritten;
        }
        return this;
    }

    public String toString(String field) {
        return "ToParentBlockJoinQuery (" + this.childQuery.toString() + ")";
    }

    public boolean equals(Object _other) {
        if (_other instanceof ToParentBlockJoinQuery) {
            ToParentBlockJoinQuery other = (ToParentBlockJoinQuery)((Object)_other);
            return this.origChildQuery.equals((Object)other.origChildQuery) && this.parentsFilter.equals(other.parentsFilter) && this.scoreMode == other.scoreMode && super.equals((Object)other);
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int hash = super.hashCode();
        hash = 31 * hash + this.origChildQuery.hashCode();
        hash = 31 * hash + this.scoreMode.hashCode();
        hash = 31 * hash + this.parentsFilter.hashCode();
        return hash;
    }

    static class BlockJoinScorer
    extends Scorer {
        private final Scorer childScorer;
        private final FixedBitSet parentBits;
        private final ScoreMode scoreMode;
        private final Bits acceptDocs;
        private int parentDoc = -1;
        private int prevParentDoc;
        private float parentScore;
        private int parentFreq;
        private int nextChildDoc;
        private int[] pendingChildDocs = new int[5];
        private float[] pendingChildScores;
        private int childDocUpto;

        public BlockJoinScorer(Weight weight, Scorer childScorer, FixedBitSet parentBits, int firstChildDoc, ScoreMode scoreMode, Bits acceptDocs) {
            super(weight);
            this.parentBits = parentBits;
            this.childScorer = childScorer;
            this.scoreMode = scoreMode;
            this.acceptDocs = acceptDocs;
            if (scoreMode != ScoreMode.None) {
                this.pendingChildScores = new float[5];
            }
            this.nextChildDoc = firstChildDoc;
        }

        public Collection<Scorer.ChildScorer> getChildren() {
            return Collections.singleton(new Scorer.ChildScorer(this.childScorer, "BLOCK_JOIN"));
        }

        int getChildCount() {
            return this.childDocUpto;
        }

        int getParentDoc() {
            return this.parentDoc;
        }

        int[] swapChildDocs(int[] other) {
            int[] ret = this.pendingChildDocs;
            this.pendingChildDocs = other == null ? new int[5] : other;
            return ret;
        }

        float[] swapChildScores(float[] other) {
            if (this.scoreMode == ScoreMode.None) {
                throw new IllegalStateException("ScoreMode is None; you must pass trackScores=false to ToParentBlockJoinCollector");
            }
            float[] ret = this.pendingChildScores;
            this.pendingChildScores = other == null ? new float[5] : other;
            return ret;
        }

        public int nextDoc() throws IOException {
            block15: {
                do {
                    if (this.nextChildDoc == Integer.MAX_VALUE) {
                        this.parentDoc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                    this.parentDoc = this.parentBits.nextSetBit(this.nextChildDoc);
                    if (this.nextChildDoc == this.parentDoc) {
                        throw new IllegalStateException("child query must only match non-parent docs, but parent docID=" + this.nextChildDoc + " matched childScorer=" + this.childScorer.getClass());
                    }
                    assert (this.parentDoc != -1);
                    if (this.acceptDocs == null || this.acceptDocs.get(this.parentDoc)) break block15;
                    do {
                        this.nextChildDoc = this.childScorer.nextDoc();
                    } while (this.nextChildDoc < this.parentDoc);
                } while (this.nextChildDoc != this.parentDoc);
                throw new IllegalStateException("child query must only match non-parent docs, but parent docID=" + this.nextChildDoc + " matched childScorer=" + this.childScorer.getClass());
            }
            float totalScore = 0.0f;
            float maxScore = Float.NEGATIVE_INFINITY;
            this.childDocUpto = 0;
            this.parentFreq = 0;
            do {
                if (this.pendingChildDocs.length == this.childDocUpto) {
                    this.pendingChildDocs = ArrayUtil.grow((int[])this.pendingChildDocs);
                }
                if (this.scoreMode != ScoreMode.None && this.pendingChildScores.length == this.childDocUpto) {
                    this.pendingChildScores = ArrayUtil.grow((float[])this.pendingChildScores);
                }
                this.pendingChildDocs[this.childDocUpto] = this.nextChildDoc;
                if (this.scoreMode != ScoreMode.None) {
                    float childScore = this.childScorer.score();
                    int childFreq = this.childScorer.freq();
                    this.pendingChildScores[this.childDocUpto] = childScore;
                    maxScore = Math.max(childScore, maxScore);
                    totalScore += childScore;
                    this.parentFreq += childFreq;
                }
                ++this.childDocUpto;
                this.nextChildDoc = this.childScorer.nextDoc();
            } while (this.nextChildDoc < this.parentDoc);
            if (this.nextChildDoc == this.parentDoc) {
                throw new IllegalStateException("child query must only match non-parent docs, but parent docID=" + this.nextChildDoc + " matched childScorer=" + this.childScorer.getClass());
            }
            switch (this.scoreMode) {
                case Avg: {
                    this.parentScore = totalScore / (float)this.childDocUpto;
                    break;
                }
                case Max: {
                    this.parentScore = maxScore;
                    break;
                }
                case Total: {
                    this.parentScore = totalScore;
                    break;
                }
            }
            return this.parentDoc;
        }

        public int docID() {
            return this.parentDoc;
        }

        public float score() throws IOException {
            return this.parentScore;
        }

        public int freq() {
            return this.parentFreq;
        }

        public int advance(int parentTarget) throws IOException {
            if (parentTarget == Integer.MAX_VALUE) {
                this.parentDoc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            if (parentTarget == 0) {
                return this.nextDoc();
            }
            this.prevParentDoc = this.parentBits.prevSetBit(parentTarget - 1);
            assert (this.prevParentDoc >= this.parentDoc);
            if (this.prevParentDoc > this.nextChildDoc) {
                this.nextChildDoc = this.childScorer.advance(this.prevParentDoc);
            }
            if (this.nextChildDoc == this.prevParentDoc) {
                throw new IllegalStateException("child query must only match non-parent docs, but parent docID=" + this.nextChildDoc + " matched childScorer=" + this.childScorer.getClass());
            }
            int nd = this.nextDoc();
            return nd;
        }

        public Explanation explain(int docBase) throws IOException {
            int start = docBase + this.prevParentDoc + 1;
            int end = docBase + this.parentDoc - 1;
            return new ComplexExplanation(true, this.score(), String.format(Locale.ROOT, "Score based on child doc range from %d to %d", start, end));
        }

        public long cost() {
            return this.childScorer.cost();
        }
    }

    private static class BlockJoinWeight
    extends Weight {
        private final Query joinQuery;
        private final Weight childWeight;
        private final Filter parentsFilter;
        private final ScoreMode scoreMode;

        public BlockJoinWeight(Query joinQuery, Weight childWeight, Filter parentsFilter, ScoreMode scoreMode) {
            this.joinQuery = joinQuery;
            this.childWeight = childWeight;
            this.parentsFilter = parentsFilter;
            this.scoreMode = scoreMode;
        }

        public Query getQuery() {
            return this.joinQuery;
        }

        public float getValueForNormalization() throws IOException {
            return this.childWeight.getValueForNormalization() * this.joinQuery.getBoost() * this.joinQuery.getBoost();
        }

        public void normalize(float norm, float topLevelBoost) {
            this.childWeight.normalize(norm, topLevelBoost * this.joinQuery.getBoost());
        }

        public Scorer scorer(AtomicReaderContext readerContext, boolean scoreDocsInOrder, boolean topScorer, Bits acceptDocs) throws IOException {
            Scorer childScorer = this.childWeight.scorer(readerContext, true, false, readerContext.reader().getLiveDocs());
            if (childScorer == null) {
                return null;
            }
            int firstChildDoc = childScorer.nextDoc();
            if (firstChildDoc == Integer.MAX_VALUE) {
                return null;
            }
            DocIdSet parents = this.parentsFilter.getDocIdSet(readerContext, null);
            if (parents == null) {
                return null;
            }
            if (!(parents instanceof FixedBitSet)) {
                throw new IllegalStateException("parentFilter must return FixedBitSet; got " + parents);
            }
            return new BlockJoinScorer(this, childScorer, (FixedBitSet)parents, firstChildDoc, this.scoreMode, acceptDocs);
        }

        public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
            BlockJoinScorer scorer = (BlockJoinScorer)this.scorer(context, true, false, context.reader().getLiveDocs());
            if (scorer != null && scorer.advance(doc) == doc) {
                return scorer.explain(context.docBase);
            }
            return new ComplexExplanation(false, 0.0f, "Not a match");
        }

        public boolean scoresDocsOutOfOrder() {
            return false;
        }
    }
}

