/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.SimpleFieldComparator;
import org.apache.lucene.search.join.BitDocIdSetFilter;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.BitSet;

public abstract class ToParentBlockJoinFieldComparator
extends SimpleFieldComparator<Object>
implements LeafFieldComparator {
    private final BitDocIdSetFilter parentFilter;
    private final BitDocIdSetFilter childFilter;
    final int spareSlot;
    FieldComparator<Object> wrappedComparator;
    LeafFieldComparator wrappedLeafComparator;
    BitSet parentDocuments;
    BitSet childDocuments;

    ToParentBlockJoinFieldComparator(FieldComparator<Object> wrappedComparator, BitDocIdSetFilter parentFilter, BitDocIdSetFilter childFilter, int spareSlot) {
        this.wrappedComparator = wrappedComparator;
        this.parentFilter = parentFilter;
        this.childFilter = childFilter;
        this.spareSlot = spareSlot;
    }

    public int compare(int slot1, int slot2) {
        return this.wrappedComparator.compare(slot1, slot2);
    }

    public void setBottom(int slot) {
        this.wrappedLeafComparator.setBottom(slot);
    }

    public void setTopValue(Object value) {
        this.wrappedComparator.setTopValue(value);
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        BitDocIdSet children = this.childFilter.getDocIdSet(context);
        this.childDocuments = children == null ? null : children.bits();
        BitDocIdSet parents = this.parentFilter.getDocIdSet(context);
        this.parentDocuments = parents == null ? null : parents.bits();
        this.wrappedLeafComparator = this.wrappedComparator.getLeafComparator(context);
    }

    public Object value(int slot) {
        return this.wrappedComparator.value(slot);
    }

    public static final class Highest
    extends ToParentBlockJoinFieldComparator
    implements LeafFieldComparator {
        public Highest(FieldComparator<Object> wrappedComparator, BitDocIdSetFilter parentFilter, BitDocIdSetFilter childFilter, int spareSlot) {
            super(wrappedComparator, parentFilter, childFilter, spareSlot);
        }

        public int compareBottom(int parentDoc) throws IOException {
            if (parentDoc == 0 || this.parentDocuments == null || this.childDocuments == null) {
                return 0;
            }
            int prevParentDoc = this.parentDocuments.prevSetBit(parentDoc - 1);
            int childDoc = this.childDocuments.nextSetBit(prevParentDoc + 1);
            if (childDoc >= parentDoc || childDoc == Integer.MAX_VALUE) {
                return 0;
            }
            int cmp = this.wrappedLeafComparator.compareBottom(childDoc);
            if (cmp < 0) {
                return cmp;
            }
            while ((childDoc = this.childDocuments.nextSetBit(childDoc + 1)) < parentDoc && childDoc != Integer.MAX_VALUE) {
                int cmp1 = this.wrappedLeafComparator.compareBottom(childDoc);
                if (cmp1 < 0) {
                    return cmp1;
                }
                if (cmp1 != 0) continue;
                cmp = 0;
            }
            return cmp;
        }

        public void copy(int slot, int parentDoc) throws IOException {
            if (parentDoc == 0 || this.parentDocuments == null || this.childDocuments == null) {
                return;
            }
            int prevParentDoc = this.parentDocuments.prevSetBit(parentDoc - 1);
            int childDoc = this.childDocuments.nextSetBit(prevParentDoc + 1);
            if (childDoc >= parentDoc || childDoc == Integer.MAX_VALUE) {
                return;
            }
            this.wrappedLeafComparator.copy(this.spareSlot, childDoc);
            this.wrappedLeafComparator.copy(slot, childDoc);
            while ((childDoc = this.childDocuments.nextSetBit(childDoc + 1)) < parentDoc && childDoc != Integer.MAX_VALUE) {
                this.wrappedLeafComparator.copy(this.spareSlot, childDoc);
                if (this.wrappedComparator.compare(this.spareSlot, slot) <= 0) continue;
                this.wrappedLeafComparator.copy(slot, childDoc);
            }
            return;
        }

        public int compareTop(int parentDoc) throws IOException {
            if (parentDoc == 0 || this.parentDocuments == null || this.childDocuments == null) {
                return 0;
            }
            int prevParentDoc = this.parentDocuments.prevSetBit(parentDoc - 1);
            int childDoc = this.childDocuments.nextSetBit(prevParentDoc + 1);
            if (childDoc >= parentDoc || childDoc == Integer.MAX_VALUE) {
                return 0;
            }
            int cmp = this.wrappedLeafComparator.compareBottom(childDoc);
            if (cmp < 0) {
                return cmp;
            }
            while ((childDoc = this.childDocuments.nextSetBit(childDoc + 1)) < parentDoc && childDoc != Integer.MAX_VALUE) {
                int cmp1 = this.wrappedLeafComparator.compareTop(childDoc);
                if (cmp1 < 0) {
                    return cmp1;
                }
                if (cmp1 != 0) continue;
                cmp = 0;
            }
            return cmp;
        }
    }

    public static final class Lowest
    extends ToParentBlockJoinFieldComparator
    implements LeafFieldComparator {
        public Lowest(FieldComparator<Object> wrappedComparator, BitDocIdSetFilter parentFilter, BitDocIdSetFilter childFilter, int spareSlot) {
            super(wrappedComparator, parentFilter, childFilter, spareSlot);
        }

        public int compareBottom(int parentDoc) throws IOException {
            if (parentDoc == 0 || this.parentDocuments == null || this.childDocuments == null) {
                return 0;
            }
            int prevParentDoc = this.parentDocuments.prevSetBit(parentDoc - 1);
            int childDoc = this.childDocuments.nextSetBit(prevParentDoc + 1);
            if (childDoc >= parentDoc || childDoc == Integer.MAX_VALUE) {
                return 0;
            }
            int cmp = this.wrappedLeafComparator.compareBottom(childDoc);
            if (cmp > 0) {
                return cmp;
            }
            while ((childDoc = this.childDocuments.nextSetBit(childDoc + 1)) < parentDoc && childDoc != Integer.MAX_VALUE) {
                int cmp1 = this.wrappedLeafComparator.compareBottom(childDoc);
                if (cmp1 > 0) {
                    return cmp1;
                }
                if (cmp1 != 0) continue;
                cmp = 0;
            }
            return cmp;
        }

        public void copy(int slot, int parentDoc) throws IOException {
            if (parentDoc == 0 || this.parentDocuments == null || this.childDocuments == null) {
                return;
            }
            int prevParentDoc = this.parentDocuments.prevSetBit(parentDoc - 1);
            int childDoc = this.childDocuments.nextSetBit(prevParentDoc + 1);
            if (childDoc >= parentDoc || childDoc == Integer.MAX_VALUE) {
                return;
            }
            this.wrappedLeafComparator.copy(this.spareSlot, childDoc);
            this.wrappedLeafComparator.copy(slot, childDoc);
            while ((childDoc = this.childDocuments.nextSetBit(childDoc + 1)) < parentDoc && childDoc != Integer.MAX_VALUE) {
                this.wrappedLeafComparator.copy(this.spareSlot, childDoc);
                if (this.wrappedComparator.compare(this.spareSlot, slot) >= 0) continue;
                this.wrappedLeafComparator.copy(slot, childDoc);
            }
            return;
        }

        public int compareTop(int parentDoc) throws IOException {
            if (parentDoc == 0 || this.parentDocuments == null || this.childDocuments == null) {
                return 0;
            }
            int prevParentDoc = this.parentDocuments.prevSetBit(parentDoc - 1);
            int childDoc = this.childDocuments.nextSetBit(prevParentDoc + 1);
            if (childDoc >= parentDoc || childDoc == Integer.MAX_VALUE) {
                return 0;
            }
            int cmp = this.wrappedLeafComparator.compareBottom(childDoc);
            if (cmp > 0) {
                return cmp;
            }
            while ((childDoc = this.childDocuments.nextSetBit(childDoc + 1)) < parentDoc && childDoc != Integer.MAX_VALUE) {
                int cmp1 = this.wrappedLeafComparator.compareTop(childDoc);
                if (cmp1 > 0) {
                    return cmp1;
                }
                if (cmp1 != 0) continue;
                cmp = 0;
            }
            return cmp;
        }
    }
}

