/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.MapFieldSelector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.ReaderUtil;
import org.apache.lucene.util.Version;

public class IndexSorter {
    private static final Logger LOG = Logger.getLogger(IndexSorter.class.getName());

    public void sort(Directory input, Directory output, String field) throws IOException {
        LOG.info("IndexSorter: starting.");
        long start = System.currentTimeMillis();
        IndexReader reader = IndexReader.open((Directory)input, (boolean)true);
        SortingReader sorter = new SortingReader(reader, IndexSorter.oldToNew(reader, field));
        IndexWriterConfig cfg = new IndexWriterConfig(Version.LUCENE_31, (Analyzer)new WhitespaceAnalyzer(Version.LUCENE_31));
        IndexWriter writer = new IndexWriter(output, cfg);
        writer.addIndexes(new IndexReader[]{sorter});
        writer.close();
        long end = System.currentTimeMillis();
        LOG.info("IndexSorter: done, " + (end - start) + " total milliseconds");
    }

    private static int[] oldToNew(IndexReader reader, String field) throws IOException {
        Object docScore;
        int readerMax = reader.maxDoc();
        Object[] newToOld = new DocScore[readerMax];
        MapFieldSelector fSel = new MapFieldSelector(new String[]{field});
        for (int oldDoc = 0; oldDoc < readerMax; ++oldDoc) {
            float score;
            if (reader.isDeleted(oldDoc)) {
                score = 0.0f;
            } else {
                Document d = reader.document(oldDoc, (FieldSelector)fSel);
                try {
                    score = Float.parseFloat(d.get(field));
                }
                catch (Exception e) {
                    score = 0.0f;
                }
            }
            docScore = new DocScore();
            ((DocScore)docScore).oldDoc = oldDoc;
            ((DocScore)docScore).score = score;
            newToOld[oldDoc] = docScore;
        }
        Arrays.sort(newToOld);
        int[] oldToNew = new int[readerMax];
        int newDoc = 0;
        while (newDoc < readerMax) {
            docScore = newToOld[newDoc];
            oldToNew[((DocScore)docScore).oldDoc] = newDoc++;
        }
        return oldToNew;
    }

    public static void main(String[] args) throws Exception {
        String usage = "IndexSorter <input> <output> <field>";
        if (args.length < 3) {
            System.err.println("Usage: " + usage);
            System.exit(-1);
        }
        FSDirectory input = FSDirectory.open((File)new File(args[0]));
        File out = new File(args[1]);
        if (!out.exists()) {
            out.mkdirs();
        }
        FSDirectory output = FSDirectory.open((File)out);
        String field = args[2];
        IndexSorter sorter = new IndexSorter();
        try {
            sorter.sort((Directory)input, (Directory)output, field);
        }
        catch (Exception e) {
            LOG.warning("IndexSorter: " + e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DocScore
    implements Comparable<DocScore> {
        private int oldDoc;
        private float score;

        private DocScore() {
        }

        @Override
        public int compareTo(DocScore that) {
            if (this.score == that.score) {
                return this.oldDoc - that.oldDoc;
            }
            return this.score < that.score ? 1 : -1;
        }

        public String toString() {
            return "oldDoc=" + this.oldDoc + ",score=" + this.score;
        }
    }

    private static class SortingReader
    extends FilterIndexReader {
        private int[] oldToNew;
        private int[] newToOld;

        public SortingReader(IndexReader oldReader, int[] oldToNew) {
            super(oldReader);
            this.oldToNew = oldToNew;
            this.newToOld = new int[oldReader.maxDoc()];
            for (int oldDoc = 0; oldDoc < oldToNew.length; ++oldDoc) {
                int newDoc = oldToNew[oldDoc];
                if (newDoc == -1) continue;
                this.newToOld[newDoc] = oldDoc;
            }
        }

        public IndexReader[] getSequentialSubReaders() {
            return null;
        }

        public FieldInfos getFieldInfos() {
            return ReaderUtil.getMergedFieldInfos((IndexReader)this.in);
        }

        public Document document(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
            return super.document(this.newToOld[n], fieldSelector);
        }

        public boolean isDeleted(int n) {
            return false;
        }

        public byte[] norms(String f) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void norms(String f, byte[] norms, int offset) throws IOException {
            byte[] oldNorms = super.norms(f);
            for (int oldDoc = 0; oldDoc < oldNorms.length; ++oldDoc) {
                int newDoc = this.oldToNew[oldDoc];
                if (newDoc == -1) continue;
                norms[newDoc] = oldNorms[oldDoc];
            }
        }

        protected void doSetNorm(int d, String f, byte b) throws IOException {
            throw new UnsupportedOperationException();
        }

        public TermDocs termDocs() throws IOException {
            throw new UnsupportedOperationException();
        }

        public TermPositions termPositions() throws IOException {
            return new SortedTermPositions(super.termPositions(), this.oldToNew);
        }

        public TermFreqVector[] getTermFreqVectors(int docNumber) throws IOException {
            return super.getTermFreqVectors(this.newToOld[docNumber]);
        }

        protected void doDelete(int n) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static class SortedTermPositions
    implements TermPositions {
        private TermPositions original;
        private int[] oldToNew;
        private int docFreq;
        private PostingMap[] postingMaps = new PostingMap[0];
        private int pointer;
        private int freq;
        private int position;
        private static final String TEMP_FILE = "temp";
        private final RAMDirectory tempDir = new RAMDirectory();
        private RAMOutputStream out;
        private IndexInput in;

        public SortedTermPositions(TermPositions original, int[] oldToNew) {
            this.original = original;
            this.oldToNew = oldToNew;
            try {
                this.out = (RAMOutputStream)this.tempDir.createOutput(TEMP_FILE);
            }
            catch (IOException ioe) {
                LOG.warning("Error creating temporary output: " + ioe);
            }
        }

        public void seek(Term term) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void seek(TermEnum terms) throws IOException {
            this.original.seek(terms);
            this.docFreq = terms.docFreq();
            this.pointer = -1;
            if (this.docFreq > this.postingMaps.length) {
                PostingMap[] newMap = new PostingMap[this.docFreq];
                System.arraycopy(this.postingMaps, 0, newMap, 0, this.postingMaps.length);
                for (int i = this.postingMaps.length; i < this.docFreq; ++i) {
                    newMap[i] = new PostingMap();
                }
                this.postingMaps = newMap;
            }
            this.out.reset();
            int i = 0;
            while (this.original.next()) {
                PostingMap map = this.postingMaps[i++];
                map.newDoc = this.oldToNew[this.original.doc()];
                map.offset = this.out.getFilePointer();
                int tf = this.original.freq();
                this.out.writeVInt(tf);
                int prevPosition = 0;
                for (int j = tf; j > 0; --j) {
                    int p = this.original.nextPosition();
                    this.out.writeVInt(p - prevPosition);
                    prevPosition = p;
                }
            }
            this.out.flush();
            this.docFreq = i;
            Arrays.sort(this.postingMaps, 0, this.docFreq);
            this.in = this.tempDir.openInput(TEMP_FILE);
        }

        public boolean next() throws IOException {
            ++this.pointer;
            if (this.pointer < this.docFreq) {
                this.in.seek(this.postingMaps[this.pointer].offset);
                this.freq = this.in.readVInt();
                this.position = 0;
                return true;
            }
            return false;
        }

        public int doc() {
            return this.postingMaps[this.pointer].newDoc;
        }

        public int freq() {
            return this.freq;
        }

        public int nextPosition() throws IOException {
            int positionIncrement = this.in.readVInt();
            this.position += positionIncrement;
            return this.position;
        }

        public int read(int[] docs, int[] freqs) {
            throw new UnsupportedOperationException();
        }

        public boolean skipTo(int target) {
            throw new UnsupportedOperationException();
        }

        public byte[] getPayload(byte[] data, int offset) throws IOException {
            return null;
        }

        public int getPayloadLength() {
            return 0;
        }

        public boolean isPayloadAvailable() {
            return false;
        }

        public void close() throws IOException {
            this.original.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PostingMap
    implements Comparable<PostingMap> {
        private int newDoc;
        private long offset;

        private PostingMap() {
        }

        @Override
        public int compareTo(PostingMap pm) {
            return this.newDoc - pm.newDoc;
        }
    }
}

