/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index.sorter;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SlowCompositeReaderWrapper;
import org.apache.lucene.index.sorter.Sorter;
import org.apache.lucene.index.sorter.SortingAtomicReader;
import org.apache.lucene.search.Sort;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.packed.PackedLongValues;

public final class SortingMergePolicy
extends MergePolicy {
    public static final String SORTER_ID_PROP = "sorter";
    final MergePolicy in;
    final Sorter sorter;
    final Sort sort;

    public static boolean isSorted(AtomicReader reader, Sort sort) {
        if (reader instanceof SegmentReader) {
            SegmentReader segReader = (SegmentReader)reader;
            Map diagnostics = segReader.getSegmentInfo().info.getDiagnostics();
            if (diagnostics != null && sort.toString().equals(diagnostics.get(SORTER_ID_PROP))) {
                return true;
            }
        }
        return false;
    }

    private MergePolicy.MergeSpecification sortedMergeSpecification(MergePolicy.MergeSpecification specification) {
        if (specification == null) {
            return null;
        }
        SortingMergeSpecification sortingSpec = new SortingMergeSpecification();
        for (MergePolicy.OneMerge merge : specification.merges) {
            sortingSpec.add(merge);
        }
        return sortingSpec;
    }

    public SortingMergePolicy(MergePolicy in, Sort sort) {
        this.in = in;
        this.sorter = new Sorter(sort);
        this.sort = sort;
    }

    public MergePolicy.MergeSpecification findMerges(MergeTrigger mergeTrigger, SegmentInfos segmentInfos, IndexWriter writer) throws IOException {
        return this.sortedMergeSpecification(this.in.findMerges(mergeTrigger, segmentInfos, writer));
    }

    public MergePolicy.MergeSpecification findForcedMerges(SegmentInfos segmentInfos, int maxSegmentCount, Map<SegmentCommitInfo, Boolean> segmentsToMerge, IndexWriter writer) throws IOException {
        return this.sortedMergeSpecification(this.in.findForcedMerges(segmentInfos, maxSegmentCount, segmentsToMerge, writer));
    }

    public MergePolicy.MergeSpecification findForcedDeletesMerges(SegmentInfos segmentInfos, IndexWriter writer) throws IOException {
        return this.sortedMergeSpecification(this.in.findForcedDeletesMerges(segmentInfos, writer));
    }

    public boolean useCompoundFile(SegmentInfos segments, SegmentCommitInfo newSegment, IndexWriter writer) throws IOException {
        return this.in.useCompoundFile(segments, newSegment, writer);
    }

    public String toString() {
        return "SortingMergePolicy(" + this.in + ", sorter=" + this.sorter + ")";
    }

    class SortingMergeSpecification
    extends MergePolicy.MergeSpecification {
        SortingMergeSpecification() {
        }

        public void add(MergePolicy.OneMerge merge) {
            super.add((MergePolicy.OneMerge)new SortingOneMerge(merge.segments));
        }

        public String segString(Directory dir) {
            return "SortingMergeSpec(" + super.segString(dir) + ", sorter=" + SortingMergePolicy.this.sorter + ")";
        }
    }

    class SortingOneMerge
    extends MergePolicy.OneMerge {
        List<AtomicReader> unsortedReaders;
        Sorter.DocMap docMap;
        AtomicReader sortedView;

        SortingOneMerge(List<SegmentCommitInfo> segments) {
            super(segments);
        }

        public List<AtomicReader> getMergeReaders() throws IOException {
            if (this.unsortedReaders == null) {
                AtomicReader atomicView;
                this.unsortedReaders = super.getMergeReaders();
                if (this.unsortedReaders.size() == 1) {
                    atomicView = this.unsortedReaders.get(0);
                } else {
                    MultiReader multiReader = new MultiReader((IndexReader[])this.unsortedReaders.toArray(new AtomicReader[this.unsortedReaders.size()]));
                    atomicView = SlowCompositeReaderWrapper.wrap((IndexReader)multiReader);
                }
                this.docMap = SortingMergePolicy.this.sorter.sort(atomicView);
                this.sortedView = SortingAtomicReader.wrap(atomicView, this.docMap);
            }
            return this.docMap == null ? this.unsortedReaders : Collections.singletonList(this.sortedView);
        }

        public void setInfo(SegmentCommitInfo info) {
            Map diagnostics = info.info.getDiagnostics();
            diagnostics.put(SortingMergePolicy.SORTER_ID_PROP, SortingMergePolicy.this.sorter.getID());
            super.setInfo(info);
        }

        private PackedLongValues getDeletes(List<AtomicReader> readers) {
            PackedLongValues.Builder deletes = PackedLongValues.monotonicBuilder((float)0.0f);
            int deleteCount = 0;
            for (AtomicReader reader : readers) {
                int maxDoc = reader.maxDoc();
                Bits liveDocs = reader.getLiveDocs();
                for (int i = 0; i < maxDoc; ++i) {
                    if (liveDocs != null && !liveDocs.get(i)) {
                        ++deleteCount;
                        continue;
                    }
                    deletes.add((long)deleteCount);
                }
            }
            return deletes.build();
        }

        public MergePolicy.DocMap getDocMap(final MergeState mergeState) {
            if (this.unsortedReaders == null) {
                throw new IllegalStateException();
            }
            if (this.docMap == null) {
                return super.getDocMap(mergeState);
            }
            assert (mergeState.docMaps.length == 1);
            final PackedLongValues deletes = this.getDeletes(this.unsortedReaders);
            return new MergePolicy.DocMap(){

                public int map(int old) {
                    int oldWithDeletes = old + (int)deletes.get(old);
                    int newWithDeletes = SortingOneMerge.this.docMap.oldToNew(oldWithDeletes);
                    return mergeState.docMaps[0].get(newWithDeletes);
                }
            };
        }
    }
}

