/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.misc.search;

import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;

public final class HumanReadableQuery
extends Query {
    private final Query in;
    private final String description;

    public HumanReadableQuery(Query in, String description) {
        this.in = in;
        this.description = description;
    }

    public Query getWrappedQuery() {
        return this.in;
    }

    public String getDescription() {
        return this.description;
    }

    public Query rewrite(IndexSearcher indexSearcher) {
        return this.in;
    }

    public String toString(String field) {
        return this.getDescription() + ":" + this.in.toString(field);
    }

    public void visit(QueryVisitor visitor) {
        this.in.visit(visitor);
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.in.equals((Object)((HumanReadableQuery)((Object)other)).in);
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) {
        throw new UnsupportedOperationException("HumanReadableQuery does not support #createWeight()");
    }

    public int hashCode() {
        return 31 * this.classHash() + this.in.hashCode();
    }
}

