/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.similar;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public final class SimilarityQueries {
    private SimilarityQueries() {
    }

    public static Query formSimilarQuery(String body, Analyzer a, String field, Set stop) throws IOException {
        Token t;
        TokenStream ts = a.tokenStream(field, (Reader)new StringReader(body));
        BooleanQuery tmp = new BooleanQuery();
        HashSet<String> already = new HashSet<String>();
        while ((t = ts.next()) != null) {
            String word = t.termText();
            if (stop != null && stop.contains(word) || !already.add(word)) continue;
            TermQuery tq = new TermQuery(new Term(field, word));
            try {
                tmp.add((Query)tq, false, false);
            }
            catch (BooleanQuery.TooManyClauses too) {
                break;
            }
        }
        return tmp;
    }
}

