/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.spatial.util.GeoRelationUtils;
import org.apache.lucene.spatial.util.GeoUtils;
import org.apache.lucene.util.DocIdSetBuilder;

final class LatLonPointInPolygonQuery
extends Query {
    final String field;
    final double minLat;
    final double maxLat;
    final double minLon;
    final double maxLon;
    final double[] polyLats;
    final double[] polyLons;

    public LatLonPointInPolygonQuery(String field, double[] polyLats, double[] polyLons) {
        this.field = field;
        if (field == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
        if (polyLats == null) {
            throw new IllegalArgumentException("polyLats cannot be null");
        }
        if (polyLons == null) {
            throw new IllegalArgumentException("polyLons cannot be null");
        }
        if (polyLats.length != polyLons.length) {
            throw new IllegalArgumentException("polyLats and polyLons must be equal length");
        }
        if (polyLats.length < 4) {
            throw new IllegalArgumentException("at least 4 polygon points required");
        }
        if (polyLats[0] != polyLats[polyLats.length - 1]) {
            throw new IllegalArgumentException("first and last points of the polygon must be the same (it must close itself): polyLats[0]=" + polyLats[0] + " polyLats[" + (polyLats.length - 1) + "]=" + polyLats[polyLats.length - 1]);
        }
        if (polyLons[0] != polyLons[polyLons.length - 1]) {
            throw new IllegalArgumentException("first and last points of the polygon must be the same (it must close itself): polyLons[0]=" + polyLons[0] + " polyLons[" + (polyLons.length - 1) + "]=" + polyLons[polyLons.length - 1]);
        }
        this.polyLats = polyLats;
        this.polyLons = polyLons;
        double minLon = Double.POSITIVE_INFINITY;
        double minLat = Double.POSITIVE_INFINITY;
        double maxLon = Double.NEGATIVE_INFINITY;
        double maxLat = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < polyLats.length; ++i) {
            double lat = polyLats[i];
            GeoUtils.checkLatitude((double)lat);
            minLat = Math.min(minLat, lat);
            maxLat = Math.max(maxLat, lat);
            double lon = polyLons[i];
            GeoUtils.checkLongitude((double)lon);
            minLon = Math.min(minLon, lon);
            maxLon = Math.max(maxLon, lon);
        }
        this.minLon = minLon;
        this.maxLon = maxLon;
        this.minLat = minLat;
        this.maxLat = maxLat;
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new ConstantScoreWeight(this){

            public Scorer scorer(LeafReaderContext context) throws IOException {
                LeafReader reader = context.reader();
                PointValues values = reader.getPointValues();
                if (values == null) {
                    return null;
                }
                FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(LatLonPointInPolygonQuery.this.field);
                if (fieldInfo == null) {
                    return null;
                }
                LatLonPoint.checkCompatible(fieldInfo);
                final DocIdSetBuilder result = new DocIdSetBuilder(reader.maxDoc());
                values.intersect(LatLonPointInPolygonQuery.this.field, new PointValues.IntersectVisitor(){

                    public void visit(int docID) {
                        result.add(docID);
                    }

                    public void visit(int docID, byte[] packedValue) {
                        double lon;
                        assert (packedValue.length == 8);
                        double lat = LatLonPoint.decodeLatitude(packedValue, 0);
                        if (GeoRelationUtils.pointInPolygon((double[])LatLonPointInPolygonQuery.this.polyLats, (double[])LatLonPointInPolygonQuery.this.polyLons, (double)lat, (double)(lon = LatLonPoint.decodeLongitude(packedValue, 4)))) {
                            result.add(docID);
                        }
                    }

                    public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                        double cellMinLat = LatLonPoint.decodeLatitude(minPackedValue, 0);
                        double cellMinLon = LatLonPoint.decodeLongitude(minPackedValue, 4);
                        double cellMaxLat = LatLonPoint.decodeLatitude(maxPackedValue, 0);
                        double cellMaxLon = LatLonPoint.decodeLongitude(maxPackedValue, 4);
                        if (cellMinLat <= LatLonPointInPolygonQuery.this.minLat && cellMaxLat >= LatLonPointInPolygonQuery.this.maxLat && cellMinLon <= LatLonPointInPolygonQuery.this.minLon && cellMaxLon >= LatLonPointInPolygonQuery.this.maxLon) {
                            return PointValues.Relation.CELL_CROSSES_QUERY;
                        }
                        if (GeoRelationUtils.rectWithinPolyPrecise((double)cellMinLat, (double)cellMaxLat, (double)cellMinLon, (double)cellMaxLon, (double[])LatLonPointInPolygonQuery.this.polyLats, (double[])LatLonPointInPolygonQuery.this.polyLons, (double)LatLonPointInPolygonQuery.this.minLat, (double)LatLonPointInPolygonQuery.this.maxLat, (double)LatLonPointInPolygonQuery.this.minLon, (double)LatLonPointInPolygonQuery.this.maxLon)) {
                            return PointValues.Relation.CELL_INSIDE_QUERY;
                        }
                        if (GeoRelationUtils.rectCrossesPolyPrecise((double)cellMinLat, (double)cellMaxLat, (double)cellMinLon, (double)cellMaxLon, (double[])LatLonPointInPolygonQuery.this.polyLats, (double[])LatLonPointInPolygonQuery.this.polyLons, (double)LatLonPointInPolygonQuery.this.minLat, (double)LatLonPointInPolygonQuery.this.maxLat, (double)LatLonPointInPolygonQuery.this.minLon, (double)LatLonPointInPolygonQuery.this.maxLon)) {
                            return PointValues.Relation.CELL_CROSSES_QUERY;
                        }
                        return PointValues.Relation.CELL_OUTSIDE_QUERY;
                    }
                });
                return new ConstantScoreScorer((Weight)this, this.score(), result.build().iterator());
            }
        };
    }

    public String getField() {
        return this.field;
    }

    public double getMinLat() {
        return this.minLat;
    }

    public double getMaxLat() {
        return this.maxLat;
    }

    public double getMinLon() {
        return this.minLon;
    }

    public double getMaxLon() {
        return this.maxLon;
    }

    public double[] getPolyLats() {
        return this.polyLats;
    }

    public double[] getPolyLons() {
        return this.polyLons;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LatLonPointInPolygonQuery that = (LatLonPointInPolygonQuery)((Object)o);
        if (!this.field.equals(that.field)) {
            return false;
        }
        if (!Arrays.equals(this.polyLons, that.polyLons)) {
            return false;
        }
        return Arrays.equals(this.polyLats, that.polyLats);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.field.hashCode();
        result = 31 * result + Arrays.hashCode(this.polyLons);
        result = 31 * result + Arrays.hashCode(this.polyLats);
        return result;
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append(" Points: ");
        for (int i = 0; i < this.polyLons.length; ++i) {
            sb.append("[").append(this.polyLats[i]).append(", ").append(this.polyLons[i]).append("] ");
        }
        return sb.toString();
    }
}

