/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.SloppyMath;
import org.apache.lucene.util.StringHelper;

final class LatLonPointDistanceQuery
extends Query {
    final String field;
    final double latitude;
    final double longitude;
    final double radiusMeters;

    public LatLonPointDistanceQuery(String field, double latitude, double longitude, double radiusMeters) {
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        if (!Double.isFinite(radiusMeters) || radiusMeters < 0.0) {
            throw new IllegalArgumentException("radiusMeters: '" + radiusMeters + "' is invalid");
        }
        GeoUtils.checkLatitude((double)latitude);
        GeoUtils.checkLongitude((double)longitude);
        this.field = field;
        this.latitude = latitude;
        this.longitude = longitude;
        this.radiusMeters = radiusMeters;
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        Rectangle box = Rectangle.fromPointDistance((double)this.latitude, (double)this.longitude, (double)this.radiusMeters);
        final byte[] minLat = new byte[4];
        final byte[] maxLat = new byte[4];
        final byte[] minLon = new byte[4];
        final byte[] maxLon = new byte[4];
        final byte[] minLon2 = new byte[4];
        NumericUtils.intToSortableBytes((int)GeoEncodingUtils.encodeLatitude((double)box.minLat), (byte[])minLat, (int)0);
        NumericUtils.intToSortableBytes((int)GeoEncodingUtils.encodeLatitude((double)box.maxLat), (byte[])maxLat, (int)0);
        if (box.crossesDateline()) {
            NumericUtils.intToSortableBytes((int)Integer.MIN_VALUE, (byte[])minLon, (int)0);
            NumericUtils.intToSortableBytes((int)GeoEncodingUtils.encodeLongitude((double)box.maxLon), (byte[])maxLon, (int)0);
            NumericUtils.intToSortableBytes((int)GeoEncodingUtils.encodeLongitude((double)box.minLon), (byte[])minLon2, (int)0);
        } else {
            NumericUtils.intToSortableBytes((int)GeoEncodingUtils.encodeLongitude((double)box.minLon), (byte[])minLon, (int)0);
            NumericUtils.intToSortableBytes((int)GeoEncodingUtils.encodeLongitude((double)box.maxLon), (byte[])maxLon, (int)0);
            NumericUtils.intToSortableBytes((int)Integer.MAX_VALUE, (byte[])minLon2, (int)0);
        }
        final double sortKey = LatLonPointDistanceQuery.sortKey(this.radiusMeters);
        final double axisLat = Rectangle.axisLat((double)this.latitude, (double)this.radiusMeters);
        return new ConstantScoreWeight(this){

            public Scorer scorer(LeafReaderContext context) throws IOException {
                LeafReader reader = context.reader();
                PointValues values = reader.getPointValues();
                if (values == null) {
                    return null;
                }
                FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(LatLonPointDistanceQuery.this.field);
                if (fieldInfo == null) {
                    return null;
                }
                LatLonPoint.checkCompatible(fieldInfo);
                final DocIdSetBuilder result = new DocIdSetBuilder(reader.maxDoc(), values, LatLonPointDistanceQuery.this.field);
                values.intersect(LatLonPointDistanceQuery.this.field, new PointValues.IntersectVisitor(){
                    DocIdSetBuilder.BulkAdder adder;

                    public void grow(int count) {
                        this.adder = result.grow(count);
                    }

                    public void visit(int docID) {
                        this.adder.add(docID);
                    }

                    public void visit(int docID, byte[] packedValue) {
                        double docLongitude;
                        if (StringHelper.compare((int)4, (byte[])packedValue, (int)0, (byte[])maxLat, (int)0) > 0 || StringHelper.compare((int)4, (byte[])packedValue, (int)0, (byte[])minLat, (int)0) < 0) {
                            return;
                        }
                        if ((StringHelper.compare((int)4, (byte[])packedValue, (int)4, (byte[])maxLon, (int)0) > 0 || StringHelper.compare((int)4, (byte[])packedValue, (int)4, (byte[])minLon, (int)0) < 0) && StringHelper.compare((int)4, (byte[])packedValue, (int)4, (byte[])minLon2, (int)0) < 0) {
                            return;
                        }
                        double docLatitude = GeoEncodingUtils.decodeLatitude((byte[])packedValue, (int)0);
                        if (SloppyMath.haversinSortKey((double)LatLonPointDistanceQuery.this.latitude, (double)LatLonPointDistanceQuery.this.longitude, (double)docLatitude, (double)(docLongitude = GeoEncodingUtils.decodeLongitude((byte[])packedValue, (int)4))) <= sortKey) {
                            this.adder.add(docID);
                        }
                    }

                    public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                        if (StringHelper.compare((int)4, (byte[])minPackedValue, (int)0, (byte[])maxLat, (int)0) > 0 || StringHelper.compare((int)4, (byte[])maxPackedValue, (int)0, (byte[])minLat, (int)0) < 0) {
                            return PointValues.Relation.CELL_OUTSIDE_QUERY;
                        }
                        if ((StringHelper.compare((int)4, (byte[])minPackedValue, (int)4, (byte[])maxLon, (int)0) > 0 || StringHelper.compare((int)4, (byte[])maxPackedValue, (int)4, (byte[])minLon, (int)0) < 0) && StringHelper.compare((int)4, (byte[])maxPackedValue, (int)4, (byte[])minLon2, (int)0) < 0) {
                            return PointValues.Relation.CELL_OUTSIDE_QUERY;
                        }
                        double latMin = GeoEncodingUtils.decodeLatitude((byte[])minPackedValue, (int)0);
                        double lonMin = GeoEncodingUtils.decodeLongitude((byte[])minPackedValue, (int)4);
                        double latMax = GeoEncodingUtils.decodeLatitude((byte[])maxPackedValue, (int)0);
                        double lonMax = GeoEncodingUtils.decodeLongitude((byte[])maxPackedValue, (int)4);
                        if ((LatLonPointDistanceQuery.this.longitude < lonMin || LatLonPointDistanceQuery.this.longitude > lonMax) && (axisLat + 8.993203677616636E-7 < latMin || axisLat - 8.993203677616636E-7 > latMax) && SloppyMath.haversinSortKey((double)LatLonPointDistanceQuery.this.latitude, (double)LatLonPointDistanceQuery.this.longitude, (double)latMin, (double)lonMin) > sortKey && SloppyMath.haversinSortKey((double)LatLonPointDistanceQuery.this.latitude, (double)LatLonPointDistanceQuery.this.longitude, (double)latMin, (double)lonMax) > sortKey && SloppyMath.haversinSortKey((double)LatLonPointDistanceQuery.this.latitude, (double)LatLonPointDistanceQuery.this.longitude, (double)latMax, (double)lonMin) > sortKey && SloppyMath.haversinSortKey((double)LatLonPointDistanceQuery.this.latitude, (double)LatLonPointDistanceQuery.this.longitude, (double)latMax, (double)lonMax) > sortKey) {
                            return PointValues.Relation.CELL_OUTSIDE_QUERY;
                        }
                        if (lonMax - LatLonPointDistanceQuery.this.longitude < 90.0 && LatLonPointDistanceQuery.this.longitude - lonMin < 90.0 && SloppyMath.haversinSortKey((double)LatLonPointDistanceQuery.this.latitude, (double)LatLonPointDistanceQuery.this.longitude, (double)latMin, (double)lonMin) <= sortKey && SloppyMath.haversinSortKey((double)LatLonPointDistanceQuery.this.latitude, (double)LatLonPointDistanceQuery.this.longitude, (double)latMin, (double)lonMax) <= sortKey && SloppyMath.haversinSortKey((double)LatLonPointDistanceQuery.this.latitude, (double)LatLonPointDistanceQuery.this.longitude, (double)latMax, (double)lonMin) <= sortKey && SloppyMath.haversinSortKey((double)LatLonPointDistanceQuery.this.latitude, (double)LatLonPointDistanceQuery.this.longitude, (double)latMax, (double)lonMax) <= sortKey) {
                            return PointValues.Relation.CELL_INSIDE_QUERY;
                        }
                        return PointValues.Relation.CELL_CROSSES_QUERY;
                    }
                });
                return new ConstantScoreScorer((Weight)this, this.score(), result.build().iterator());
            }
        };
    }

    static double sortKey(double radius) {
        if (radius >= SloppyMath.haversinMeters((double)Double.MAX_VALUE)) {
            return SloppyMath.haversinMeters((double)Double.MAX_VALUE);
        }
        long lo = 0L;
        long hi = Double.doubleToRawLongBits(Double.MAX_VALUE);
        while (lo <= hi) {
            long mid = lo + hi >>> 1;
            double sortKey = Double.longBitsToDouble(mid);
            double midRadius = SloppyMath.haversinMeters((double)sortKey);
            if (midRadius == radius) {
                return sortKey;
            }
            if (midRadius > radius) {
                hi = mid - 1L;
                continue;
            }
            lo = mid + 1L;
        }
        double ceil = Double.longBitsToDouble(lo);
        assert (SloppyMath.haversinMeters((double)ceil) > radius);
        return ceil;
    }

    public String getField() {
        return this.field;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getRadiusMeters() {
        return this.radiusMeters;
    }

    public int hashCode() {
        int prime = 31;
        int result = this.classHash();
        result = 31 * result + this.field.hashCode();
        long temp = Double.doubleToLongBits(this.latitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.radiusMeters);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((LatLonPointDistanceQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
    }

    private boolean equalsTo(LatLonPointDistanceQuery other) {
        return this.field.equals(other.field) && Double.doubleToLongBits(this.latitude) == Double.doubleToLongBits(other.latitude) && Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(other.longitude) && Double.doubleToLongBits(this.radiusMeters) == Double.doubleToLongBits(other.radiusMeters);
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        if (!this.field.equals(field)) {
            sb.append(this.field);
            sb.append(':');
        }
        sb.append(this.latitude);
        sb.append(",");
        sb.append(this.longitude);
        sb.append(" +/- ");
        sb.append(this.radiusMeters);
        sb.append(" meters");
        return sb.toString();
    }
}

