/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.intervals;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.intervals.ConjunctionIntervalsSource;
import org.apache.lucene.search.intervals.Disjunctions;
import org.apache.lucene.search.intervals.FilteringIntervalIterator;
import org.apache.lucene.search.intervals.IntervalIterator;
import org.apache.lucene.search.intervals.Intervals;
import org.apache.lucene.search.intervals.IntervalsSource;

class ContainedByIntervalsSource
extends ConjunctionIntervalsSource {
    private final IntervalsSource small;
    private final IntervalsSource big;

    static IntervalsSource build(IntervalsSource small, IntervalsSource big) {
        return Intervals.or(Disjunctions.pullUp(big, s -> new ContainedByIntervalsSource(small, (IntervalsSource)s)));
    }

    private ContainedByIntervalsSource(IntervalsSource small, IntervalsSource big) {
        super(Arrays.asList(small, big), false);
        this.small = small;
        this.big = big;
    }

    @Override
    protected IntervalIterator combine(List<IntervalIterator> iterators) {
        assert (iterators.size() == 2);
        IntervalIterator a = iterators.get(0);
        IntervalIterator b = iterators.get(1);
        return new FilteringIntervalIterator(a, b){

            @Override
            public int nextInterval() throws IOException {
                if (!this.bpos) {
                    return Integer.MAX_VALUE;
                }
                while (this.a.nextInterval() != Integer.MAX_VALUE) {
                    while (this.b.end() < this.a.end()) {
                        if (this.b.nextInterval() != Integer.MAX_VALUE) continue;
                        this.bpos = false;
                        return Integer.MAX_VALUE;
                    }
                    if (this.b.start() > this.a.start()) continue;
                    return this.a.start();
                }
                this.bpos = false;
                return Integer.MAX_VALUE;
            }
        };
    }

    @Override
    public int minExtent() {
        return this.small.minExtent();
    }

    @Override
    public Collection<IntervalsSource> pullUpDisjunctions() {
        return Disjunctions.pullUp(this.big, s -> new ContainedByIntervalsSource(this.small, (IntervalsSource)s));
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.subSources);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ContainedByIntervalsSource)) {
            return false;
        }
        ContainedByIntervalsSource o = (ContainedByIntervalsSource)other;
        return Objects.equals(this.subSources, o.subSources);
    }

    @Override
    public String toString() {
        return "CONTAINED_BY(" + this.small + "," + this.big + ")";
    }
}

