/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.sandbox.search.CoveringScorer;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LongValues;
import org.apache.lucene.search.LongValuesSource;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.MatchesUtils;
import org.apache.lucene.search.Multiset;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;

public final class CoveringQuery
extends Query
implements Accountable {
    private static final long BASE_RAM_BYTES = RamUsageEstimator.shallowSizeOfInstance(CoveringQuery.class);
    private final Collection<Query> queries;
    private final LongValuesSource minimumNumberMatch;
    private final int hashCode;
    private final long ramBytesUsed;

    public CoveringQuery(Collection<Query> queries, LongValuesSource minimumNumberMatch) {
        if (queries.size() > IndexSearcher.getMaxClauseCount()) {
            throw new IndexSearcher.TooManyClauses();
        }
        if (minimumNumberMatch.needsScores()) {
            throw new IllegalArgumentException("The minimum number of matches may not depend on the score.");
        }
        this.queries = new Multiset();
        this.queries.addAll(queries);
        this.minimumNumberMatch = Objects.requireNonNull(minimumNumberMatch);
        this.hashCode = this.computeHashCode();
        this.ramBytesUsed = BASE_RAM_BYTES + RamUsageEstimator.sizeOfObject(this.queries, (long)1024L);
    }

    public String toString(String field) {
        String queriesToString = this.queries.stream().map(q -> q.toString(field)).sorted().collect(Collectors.joining(", "));
        return "CoveringQuery(queries=[" + queriesToString + "], minimumNumberMatch=" + this.minimumNumberMatch + ")";
    }

    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        CoveringQuery that = (CoveringQuery)((Object)obj);
        return this.hashCode == that.hashCode && Objects.equals(this.queries, that.queries) && Objects.equals(this.minimumNumberMatch, that.minimumNumberMatch);
    }

    private int computeHashCode() {
        int h = this.classHash();
        h = 31 * h + this.queries.hashCode();
        h = 31 * h + this.minimumNumberMatch.hashCode();
        return h;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Multiset rewritten = new Multiset();
        boolean actuallyRewritten = false;
        for (Query query : this.queries) {
            Query r = query.rewrite(reader);
            rewritten.add((Object)r);
            actuallyRewritten |= query != r;
        }
        if (actuallyRewritten) {
            return new CoveringQuery((Collection<Query>)rewritten, this.minimumNumberMatch);
        }
        return super.rewrite(reader);
    }

    public void visit(QueryVisitor visitor) {
        QueryVisitor v = visitor.getSubVisitor(BooleanClause.Occur.SHOULD, (Query)this);
        for (Query query : this.queries) {
            query.visit(v);
        }
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        ArrayList<Weight> weights = new ArrayList<Weight>(this.queries.size());
        for (Query query : this.queries) {
            weights.add(searcher.createWeight(query, scoreMode, boost));
        }
        return new CoveringWeight(this, weights, this.minimumNumberMatch.rewrite(searcher));
    }

    private static class CoveringWeight
    extends Weight {
        private final Collection<Weight> weights;
        private final LongValuesSource minimumNumberMatch;

        CoveringWeight(Query query, Collection<Weight> weights, LongValuesSource minimumNumberMatch) {
            super(query);
            this.weights = weights;
            this.minimumNumberMatch = minimumNumberMatch;
        }

        public Matches matches(LeafReaderContext context, int doc) throws IOException {
            LongValues minMatchValues = this.minimumNumberMatch.getValues(context, null);
            if (!minMatchValues.advanceExact(doc)) {
                return null;
            }
            long minimumNumberMatch = Math.max(1L, minMatchValues.longValue());
            long matchCount = 0L;
            ArrayList<Matches> subMatches = new ArrayList<Matches>();
            for (Weight weight : this.weights) {
                Matches matches = weight.matches(context, doc);
                if (matches == null) continue;
                ++matchCount;
                subMatches.add(matches);
            }
            if (matchCount < minimumNumberMatch) {
                return null;
            }
            return MatchesUtils.fromSubMatches(subMatches);
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            LongValues minMatchValues = this.minimumNumberMatch.getValues(context, null);
            if (!minMatchValues.advanceExact(doc)) {
                return Explanation.noMatch((String)"minimumNumberMatch has no value on the current document", (Explanation[])new Explanation[0]);
            }
            long minimumNumberMatch = Math.max(1L, minMatchValues.longValue());
            int freq = 0;
            double score = 0.0;
            ArrayList<Explanation> subExpls = new ArrayList<Explanation>();
            for (Weight weight : this.weights) {
                Explanation subExpl = weight.explain(context, doc);
                if (subExpl.isMatch()) {
                    ++freq;
                    score += subExpl.getValue().doubleValue();
                }
                subExpls.add(subExpl);
            }
            if ((long)freq >= minimumNumberMatch) {
                return Explanation.match((Number)Float.valueOf((float)score), (String)(freq + " matches for " + minimumNumberMatch + " required matches, sum of:"), subExpls);
            }
            return Explanation.noMatch((String)(freq + " matches for " + minimumNumberMatch + " required matches"), subExpls);
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            ArrayList<Scorer> scorers = new ArrayList<Scorer>();
            for (Weight w : this.weights) {
                Scorer s = w.scorer(context);
                if (s == null) continue;
                scorers.add(s);
            }
            if (scorers.isEmpty()) {
                return null;
            }
            return new CoveringScorer(this, scorers, this.minimumNumberMatch.getValues(context, null), context.reader().maxDoc());
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return this.minimumNumberMatch.isCacheable(ctx);
        }
    }
}

