/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.search;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.SloppyMath;

class NearestNeighbor {
    NearestNeighbor() {
    }

    public static NearestHit[] nearest(double pointLat, double pointLon, List<PointValues> readers, List<Bits> liveDocs, List<Integer> docBases, int n) throws IOException {
        PriorityQueue<NearestHit> hitQueue = new PriorityQueue<NearestHit>(n, new Comparator<NearestHit>(){

            @Override
            public int compare(NearestHit a, NearestHit b) {
                int cmp = Double.compare(a.distanceSortKey, b.distanceSortKey);
                if (cmp != 0) {
                    return -cmp;
                }
                return b.docID - a.docID;
            }
        });
        PriorityQueue<Cell> cellQueue = new PriorityQueue<Cell>();
        NearestVisitor visitor = new NearestVisitor(hitQueue, n, pointLat, pointLon);
        for (int i = 0; i < readers.size(); ++i) {
            PointValues reader = readers.get(i);
            byte[] minPackedValue = reader.getMinPackedValue();
            byte[] maxPackedValue = reader.getMaxPackedValue();
            PointValues.PointTree indexTree = reader.getPointTree();
            cellQueue.offer(new Cell(indexTree, i, reader.getMinPackedValue(), reader.getMaxPackedValue(), NearestNeighbor.approxBestDistance(minPackedValue, maxPackedValue, pointLat, pointLon)));
        }
        while (cellQueue.size() > 0) {
            Cell cell = (Cell)cellQueue.poll();
            if (visitor.compare(cell.minPacked, cell.maxPacked) == PointValues.Relation.CELL_OUTSIDE_QUERY) continue;
            if (!cell.index.moveToChild()) {
                visitor.curDocBase = docBases.get(cell.readerIndex);
                visitor.curLiveDocs = liveDocs.get(cell.readerIndex);
                cell.index.visitDocValues((PointValues.IntersectVisitor)visitor);
                continue;
            }
            PointValues.PointTree newIndex = cell.index.clone();
            cellQueue.offer(new Cell(newIndex, cell.readerIndex, newIndex.getMinPackedValue(), newIndex.getMaxPackedValue(), NearestNeighbor.approxBestDistance(newIndex.getMinPackedValue(), newIndex.getMaxPackedValue(), pointLat, pointLon)));
            if (!cell.index.moveToSibling()) continue;
            cellQueue.offer(new Cell(cell.index, cell.readerIndex, cell.index.getMinPackedValue(), cell.index.getMaxPackedValue(), NearestNeighbor.approxBestDistance(cell.index.getMinPackedValue(), cell.index.getMaxPackedValue(), pointLat, pointLon)));
        }
        NearestHit[] hits = new NearestHit[hitQueue.size()];
        int downTo = hitQueue.size() - 1;
        while (hitQueue.size() != 0) {
            hits[downTo] = hitQueue.poll();
            --downTo;
        }
        return hits;
    }

    private static double approxBestDistance(byte[] minPackedValue, byte[] maxPackedValue, double pointLat, double pointLon) {
        double minLat = GeoEncodingUtils.decodeLatitude((byte[])minPackedValue, (int)0);
        double minLon = GeoEncodingUtils.decodeLongitude((byte[])minPackedValue, (int)4);
        double maxLat = GeoEncodingUtils.decodeLatitude((byte[])maxPackedValue, (int)0);
        double maxLon = GeoEncodingUtils.decodeLongitude((byte[])maxPackedValue, (int)4);
        return NearestNeighbor.approxBestDistance(minLat, maxLat, minLon, maxLon, pointLat, pointLon);
    }

    private static double approxBestDistance(double minLat, double maxLat, double minLon, double maxLon, double pointLat, double pointLon) {
        if (pointLat >= minLat && pointLat <= maxLat && pointLon >= minLon && pointLon <= maxLon) {
            return 0.0;
        }
        double d1 = SloppyMath.haversinSortKey((double)pointLat, (double)pointLon, (double)minLat, (double)minLon);
        double d2 = SloppyMath.haversinSortKey((double)pointLat, (double)pointLon, (double)minLat, (double)maxLon);
        double d3 = SloppyMath.haversinSortKey((double)pointLat, (double)pointLon, (double)maxLat, (double)maxLon);
        double d4 = SloppyMath.haversinSortKey((double)pointLat, (double)pointLon, (double)maxLat, (double)minLon);
        return Math.min(Math.min(d1, d2), Math.min(d3, d4));
    }

    private static class NearestVisitor
    implements PointValues.IntersectVisitor {
        public int curDocBase;
        public Bits curLiveDocs;
        final int topN;
        final PriorityQueue<NearestHit> hitQueue;
        final double pointLat;
        final double pointLon;
        private int setBottomCounter;
        private double minLon = Double.NEGATIVE_INFINITY;
        private double maxLon = Double.POSITIVE_INFINITY;
        private double minLat = Double.NEGATIVE_INFINITY;
        private double maxLat = Double.POSITIVE_INFINITY;
        private double minLon2 = Double.POSITIVE_INFINITY;

        public NearestVisitor(PriorityQueue<NearestHit> hitQueue, int topN, double pointLat, double pointLon) {
            this.hitQueue = hitQueue;
            this.topN = topN;
            this.pointLat = pointLat;
            this.pointLon = pointLon;
        }

        public void visit(int docID) {
            throw new AssertionError();
        }

        private void maybeUpdateBBox() {
            if (this.setBottomCounter < 1024 || (this.setBottomCounter & 0x3F) == 63) {
                NearestHit hit = this.hitQueue.peek();
                Rectangle box = Rectangle.fromPointDistance((double)this.pointLat, (double)this.pointLon, (double)SloppyMath.haversinMeters((double)hit.distanceSortKey));
                this.minLat = box.minLat;
                this.maxLat = box.maxLat;
                if (box.crossesDateline()) {
                    this.minLon = Double.NEGATIVE_INFINITY;
                    this.maxLon = box.maxLon;
                    this.minLon2 = box.minLon;
                } else {
                    this.minLon = box.minLon;
                    this.maxLon = box.maxLon;
                    this.minLon2 = Double.POSITIVE_INFINITY;
                }
            }
            ++this.setBottomCounter;
        }

        public void visit(int docID, byte[] packedValue) {
            if (this.curLiveDocs != null && !this.curLiveDocs.get(docID)) {
                return;
            }
            double docLatitude = GeoEncodingUtils.decodeLatitude((byte[])packedValue, (int)0);
            double docLongitude = GeoEncodingUtils.decodeLongitude((byte[])packedValue, (int)4);
            if (docLatitude < this.minLat || docLatitude > this.maxLat) {
                return;
            }
            if ((docLongitude < this.minLon || docLongitude > this.maxLon) && docLongitude < this.minLon2) {
                return;
            }
            double distanceSortKey = SloppyMath.haversinSortKey((double)this.pointLat, (double)this.pointLon, (double)docLatitude, (double)docLongitude);
            int fullDocID = this.curDocBase + docID;
            if (this.hitQueue.size() == this.topN) {
                NearestHit hit = this.hitQueue.peek();
                if (distanceSortKey < hit.distanceSortKey || distanceSortKey == hit.distanceSortKey && fullDocID < hit.docID) {
                    this.hitQueue.poll();
                    hit.docID = fullDocID;
                    hit.distanceSortKey = distanceSortKey;
                    this.hitQueue.offer(hit);
                    this.maybeUpdateBBox();
                }
            } else {
                NearestHit hit = new NearestHit();
                hit.docID = fullDocID;
                hit.distanceSortKey = distanceSortKey;
                this.hitQueue.offer(hit);
            }
        }

        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
            double cellMinLat = GeoEncodingUtils.decodeLatitude((byte[])minPackedValue, (int)0);
            double cellMinLon = GeoEncodingUtils.decodeLongitude((byte[])minPackedValue, (int)4);
            double cellMaxLat = GeoEncodingUtils.decodeLatitude((byte[])maxPackedValue, (int)0);
            double cellMaxLon = GeoEncodingUtils.decodeLongitude((byte[])maxPackedValue, (int)4);
            if (cellMaxLat < this.minLat || this.maxLat < cellMinLat || (cellMaxLon < this.minLon || this.maxLon < cellMinLon) && cellMaxLon < this.minLon2) {
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }
    }

    static class Cell
    implements Comparable<Cell> {
        final int readerIndex;
        final byte[] minPacked;
        final byte[] maxPacked;
        final PointValues.PointTree index;
        final double distanceSortKey;

        public Cell(PointValues.PointTree index, int readerIndex, byte[] minPacked, byte[] maxPacked, double distanceSortKey) {
            this.index = index;
            this.readerIndex = readerIndex;
            this.minPacked = (byte[])minPacked.clone();
            this.maxPacked = (byte[])maxPacked.clone();
            this.distanceSortKey = distanceSortKey;
        }

        @Override
        public int compareTo(Cell other) {
            return Double.compare(this.distanceSortKey, other.distanceSortKey);
        }

        public String toString() {
            double minLat = GeoEncodingUtils.decodeLatitude((byte[])this.minPacked, (int)0);
            double minLon = GeoEncodingUtils.decodeLongitude((byte[])this.minPacked, (int)4);
            double maxLat = GeoEncodingUtils.decodeLatitude((byte[])this.maxPacked, (int)0);
            double maxLon = GeoEncodingUtils.decodeLongitude((byte[])this.maxPacked, (int)4);
            return "Cell(readerIndex=" + this.readerIndex + " " + this.index.toString() + " lat=" + minLat + " TO " + maxLat + ", lon=" + minLon + " TO " + maxLon + "; distanceSortKey=" + this.distanceSortKey + ")";
        }
    }

    static class NearestHit {
        public int docID;
        public double distanceSortKey;

        NearestHit() {
        }

        public String toString() {
            return "NearestHit(docID=" + this.docID + " distanceSortKey=" + this.distanceSortKey + ")";
        }
    }
}

