/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.composite;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.spatial.prefix.AbstractVisitingPrefixTreeQuery;
import org.apache.lucene.spatial.prefix.tree.Cell;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.util.DocIdSetBuilder;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.SpatialRelation;

public class IntersectsRPTVerifyQuery
extends Query {
    private final IntersectsDifferentiatingQuery intersectsDiffQuery;
    private final ValueSource predicateValueSource;

    public IntersectsRPTVerifyQuery(Shape queryShape, String fieldName, SpatialPrefixTree grid, int detailLevel, int prefixGridScanLevel, ValueSource predicateValueSource) {
        this.predicateValueSource = predicateValueSource;
        this.intersectsDiffQuery = new IntersectsDifferentiatingQuery(queryShape, fieldName, grid, detailLevel, prefixGridScanLevel);
    }

    public String toString(String field) {
        return "IntersectsVerified(fieldName=" + field + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        IntersectsRPTVerifyQuery that = (IntersectsRPTVerifyQuery)((Object)o);
        if (!this.intersectsDiffQuery.equals((Object)that.intersectsDiffQuery)) {
            return false;
        }
        return this.predicateValueSource.equals((Object)that.predicateValueSource);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.intersectsDiffQuery.hashCode();
        result = 31 * result + this.predicateValueSource.hashCode();
        return result;
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        final Map valueSourceContext = ValueSource.newContext((IndexSearcher)searcher);
        return new ConstantScoreWeight(this){

            public Scorer scorer(LeafReaderContext context) throws IOException {
                DocIdSetIterator exactIterator;
                IntersectsDifferentiatingQuery.IntersectsDifferentiatingVisitor result = IntersectsRPTVerifyQuery.this.intersectsDiffQuery.compute(context);
                if (result.approxDocIdSet == null) {
                    return null;
                }
                final DocIdSetIterator approxDISI = result.approxDocIdSet.iterator();
                if (approxDISI == null) {
                    return null;
                }
                if (result.exactDocIdSet != null) {
                    if (result.approxDocIdSet == result.exactDocIdSet) {
                        return new ConstantScoreScorer((Weight)this, this.score(), approxDISI);
                    }
                    exactIterator = result.exactDocIdSet.iterator();
                    assert (exactIterator != null);
                } else {
                    exactIterator = null;
                }
                final FunctionValues predFuncValues = IntersectsRPTVerifyQuery.this.predicateValueSource.getValues(valueSourceContext, context);
                TwoPhaseIterator twoPhaseIterator = new TwoPhaseIterator(approxDISI){

                    public boolean matches() throws IOException {
                        int doc = approxDISI.docID();
                        if (exactIterator != null) {
                            if (exactIterator.docID() < doc) {
                                exactIterator.advance(doc);
                            }
                            if (exactIterator.docID() == doc) {
                                return true;
                            }
                        }
                        return predFuncValues.boolVal(doc);
                    }

                    public float matchCost() {
                        return 100.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), twoPhaseIterator);
            }
        };
    }

    private static class IntersectsDifferentiatingQuery
    extends AbstractVisitingPrefixTreeQuery {
        public IntersectsDifferentiatingQuery(Shape queryShape, String fieldName, SpatialPrefixTree grid, int detailLevel, int prefixGridScanLevel) {
            super(queryShape, fieldName, grid, detailLevel, prefixGridScanLevel);
        }

        IntersectsDifferentiatingVisitor compute(LeafReaderContext context) throws IOException {
            IntersectsDifferentiatingVisitor result = new IntersectsDifferentiatingVisitor(context);
            result.getDocIdSet();
            return result;
        }

        @Override
        public DocIdSet getDocIdSet(LeafReaderContext context) throws IOException {
            throw new IllegalStateException();
        }

        public String toString(String field) {
            throw new IllegalStateException();
        }

        class IntersectsDifferentiatingVisitor
        extends AbstractVisitingPrefixTreeQuery.VisitorTemplate {
            DocIdSetBuilder approxBuilder;
            DocIdSetBuilder exactBuilder;
            boolean approxIsEmpty;
            boolean exactIsEmpty;
            DocIdSet exactDocIdSet;
            DocIdSet approxDocIdSet;

            public IntersectsDifferentiatingVisitor(LeafReaderContext context) throws IOException {
                super(IntersectsDifferentiatingQuery.this, context);
                this.approxBuilder = new DocIdSetBuilder(this.maxDoc);
                this.exactBuilder = new DocIdSetBuilder(this.maxDoc);
                this.approxIsEmpty = true;
                this.exactIsEmpty = true;
            }

            @Override
            protected void start() throws IOException {
            }

            @Override
            protected DocIdSet finish() throws IOException {
                this.exactDocIdSet = this.exactIsEmpty ? null : this.exactBuilder.build();
                if (this.approxIsEmpty) {
                    this.approxDocIdSet = this.exactDocIdSet;
                } else {
                    if (this.exactDocIdSet != null) {
                        this.approxBuilder.add(this.exactDocIdSet.iterator());
                    }
                    this.approxDocIdSet = this.approxBuilder.build();
                }
                return null;
            }

            @Override
            protected boolean visitPrefix(Cell cell) throws IOException {
                if (cell.getShapeRel() == SpatialRelation.WITHIN) {
                    this.exactIsEmpty = false;
                    this.collectDocs(this.exactBuilder);
                    return false;
                }
                if (cell.getLevel() == IntersectsDifferentiatingQuery.this.detailLevel) {
                    this.approxIsEmpty = false;
                    this.collectDocs(this.approxBuilder);
                    return false;
                }
                return true;
            }

            @Override
            protected void visitLeaf(Cell cell) throws IOException {
                if (cell.getShapeRel() == SpatialRelation.WITHIN) {
                    this.exactIsEmpty = false;
                    this.collectDocs(this.exactBuilder);
                } else {
                    this.approxIsEmpty = false;
                    this.collectDocs(this.approxBuilder);
                }
            }
        }
    }
}

