/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import java.io.IOException;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.BytesTermAttribute;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;

class BytesRefIteratorTokenStream
extends TokenStream {
    private final BytesTermAttribute bytesAtt = (BytesTermAttribute)this.addAttribute(BytesTermAttribute.class);
    private BytesRefIterator bytesIter = null;

    BytesRefIteratorTokenStream() {
    }

    public BytesRefIterator getBytesRefIterator() {
        return this.bytesIter;
    }

    public BytesRefIteratorTokenStream setBytesRefIterator(BytesRefIterator iter) {
        this.bytesIter = iter;
        return this;
    }

    public void reset() throws IOException {
        if (this.bytesIter == null) {
            throw new IllegalStateException("call setBytesRefIterator() before usage");
        }
    }

    public final boolean incrementToken() throws IOException {
        if (this.bytesIter == null) {
            throw new IllegalStateException("call setBytesRefIterator() before usage");
        }
        BytesRef bytes = this.bytesIter.next();
        if (bytes == null) {
            return false;
        }
        this.clearAttributes();
        this.bytesAtt.setBytesRef(bytes);
        return true;
    }
}

