/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.tier;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.spatial.tier.Shape;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.OpenBitSet;

public class CartesianShapeFilter
extends Filter {
    private static final long serialVersionUID = 1L;
    private Shape shape;
    private Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private String fieldName;

    CartesianShapeFilter(Shape shape, String fieldName) {
        this.shape = shape;
        this.fieldName = fieldName;
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        long start = System.currentTimeMillis();
        OpenBitSet bits = new OpenBitSet((long)reader.maxDoc());
        TermDocs termDocs = reader.termDocs();
        List<Double> area = this.shape.getArea();
        int sz = area.size();
        this.log.fine("Area size " + sz);
        for (int i = 0; i < sz; ++i) {
            double boxId = area.get(i);
            termDocs.seek(new Term(this.fieldName, NumericUtils.doubleToPrefixCoded((double)boxId)));
            while (termDocs.next()) {
                bits.fastSet(termDocs.doc());
            }
        }
        long end = System.currentTimeMillis();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("BoundaryBox Time Taken: " + (end - start) + " found: " + bits.cardinality() + " candidates");
        }
        return bits;
    }
}

