/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geometry.shape;

import org.apache.lucene.spatial.geometry.FloatLatLng;
import org.apache.lucene.spatial.geometry.LatLng;
import org.apache.lucene.spatial.geometry.shape.Rectangle;

@Deprecated
public class LLRect {
    private LatLng ll;
    private LatLng ur;

    public LLRect(LatLng ll, LatLng ur) {
        this.ll = ll;
        this.ur = ur;
    }

    public LLRect(LLRect other) {
        this.ll = other.ll;
        this.ur = other.ur;
    }

    public double area() {
        return Math.abs((this.ll.getLat() - this.ur.getLat()) * (this.ll.getLng() - this.ur.getLng()));
    }

    public LatLng getLowerLeft() {
        return this.ll;
    }

    public LatLng getUpperRight() {
        return this.ur;
    }

    public String toString() {
        return "{" + this.ll + ", " + this.ur + "}";
    }

    public LatLng getMidpoint() {
        return this.ll.calculateMidpoint(this.ur);
    }

    public static LLRect createBox(LatLng center, double widthMi, double heightMi) {
        double d = widthMi;
        LatLng ur = LLRect.boxCorners(center, d, 45.0);
        LatLng ll = LLRect.boxCorners(center, d, 225.0);
        return new LLRect(ll, ur);
    }

    public Rectangle toRectangle() {
        return new Rectangle(this.ll.getLng(), this.ll.getLat(), this.ur.getLng(), this.ur.getLat());
    }

    private static LatLng boxCorners(LatLng center, double d, double brngdeg) {
        double a = center.getLat();
        double b = center.getLng();
        double R = 3963.0;
        double brng = Math.PI * brngdeg / 180.0;
        double lat1 = Math.PI * a / 180.0;
        double lon1 = Math.PI * b / 180.0;
        double lat2 = Math.asin(Math.sin(lat1) * Math.cos(d / R) + Math.cos(lat1) * Math.sin(d / R) * Math.cos(brng));
        double lon2 = lon1 + Math.atan2(Math.sin(brng) * Math.sin(d / R) * Math.cos(lat1), Math.cos(d / R) - Math.sin(lat1) * Math.sin(lat2));
        lat2 = lat2 * 180.0 / Math.PI;
        lon2 = lon2 * 180.0 / Math.PI;
        LatLng ll = LLRect.normLng(lat2, lon2);
        ll = LLRect.normLat(ll.getLat(), ll.getLng());
        return ll;
    }

    private static LatLng normLat(double lat, double lng) {
        if (lat > 90.0) {
            lat = 90.0 - (lat - 90.0);
            lng = lng < 0.0 ? (lng += 180.0) : (lng -= 180.0);
        } else if (lat < -90.0) {
            lat = -90.0 - (lat + 90.0);
            lng = lng < 0.0 ? (lng += 180.0) : (lng -= 180.0);
        }
        FloatLatLng ll = new FloatLatLng(lat, lng);
        return ll;
    }

    private static LatLng normLng(double lat, double lng) {
        if (lng > 180.0) {
            lng = -1.0 * (180.0 - (lng - 180.0));
        } else if (lng < -180.0) {
            lng = lng + 180.0 + 180.0;
        }
        FloatLatLng ll = new FloatLatLng(lat, lng);
        return ll;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ll == null ? 0 : this.ll.hashCode());
        result = 31 * result + (this.ur == null ? 0 : this.ur.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LLRect other = (LLRect)obj;
        if (this.ll == null ? other.ll != null : !this.ll.equals(other.ll)) {
            return false;
        }
        return !(this.ur == null ? other.ur != null : !this.ur.equals(other.ur));
    }
}

