/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.query.SpatialArgs;
import com.spatial4j.core.shape.Shape;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.SpatialFieldInfo;

public abstract class SpatialStrategy<T extends SpatialFieldInfo> {
    protected boolean ignoreIncompatibleGeometry = false;
    protected final SpatialContext ctx;

    public SpatialStrategy(SpatialContext ctx) {
        this.ctx = ctx;
    }

    public SpatialContext getSpatialContext() {
        return this.ctx;
    }

    public boolean isPolyField() {
        return false;
    }

    public abstract IndexableField createField(T var1, Shape var2, boolean var3, boolean var4);

    public IndexableField[] createFields(T fieldInfo, Shape shape, boolean index, boolean store) {
        return new IndexableField[]{this.createField(fieldInfo, shape, index, store)};
    }

    public abstract ValueSource makeValueSource(SpatialArgs var1, T var2);

    public abstract Query makeQuery(SpatialArgs var1, T var2);

    public abstract Filter makeFilter(SpatialArgs var1, T var2);

    public boolean isIgnoreIncompatibleGeometry() {
        return this.ignoreIncompatibleGeometry;
    }

    public void setIgnoreIncompatibleGeometry(boolean ignoreIncompatibleGeometry) {
        this.ignoreIncompatibleGeometry = ignoreIncompatibleGeometry;
    }
}

