/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.util;

import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexableField;

public class NumericFieldInfo {
    public int precisionStep = 8;
    public boolean store = true;
    public boolean index = true;

    public void setPrecisionStep(int p) {
        this.precisionStep = p;
        if (this.precisionStep <= 0 || this.precisionStep >= 64) {
            this.precisionStep = Integer.MAX_VALUE;
        }
    }

    public IndexableField createDouble(String name, double v) {
        if (!this.store && !this.index) {
            throw new IllegalArgumentException("field must be indexed or stored");
        }
        FieldType fieldType = new FieldType(DoubleField.TYPE_NOT_STORED);
        fieldType.setStored(this.store);
        fieldType.setIndexed(this.index);
        fieldType.setNumericPrecisionStep(this.precisionStep);
        return new DoubleField(name, v, fieldType);
    }
}

