/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix.tree;

import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;

public abstract class Node
implements Comparable<Node> {
    public static final byte LEAF_BYTE = 43;
    private byte[] bytes;
    private int b_off;
    private int b_len;
    private String token;
    protected SpatialRelation shapeRel;
    private SpatialPrefixTree spatialPrefixTree;

    protected Node(SpatialPrefixTree spatialPrefixTree, String token) {
        this.spatialPrefixTree = spatialPrefixTree;
        this.token = token;
        if (token.length() > 0 && token.charAt(token.length() - 1) == '+') {
            this.token = token.substring(0, token.length() - 1);
            this.setLeaf();
        }
        if (this.getLevel() == 0) {
            this.getShape();
        }
    }

    protected Node(SpatialPrefixTree spatialPrefixTree, byte[] bytes, int off, int len) {
        this.spatialPrefixTree = spatialPrefixTree;
        this.bytes = bytes;
        this.b_off = off;
        this.b_len = len;
        this.b_fixLeaf();
    }

    public void reset(byte[] bytes, int off, int len) {
        assert (this.getLevel() != 0);
        this.token = null;
        this.shapeRel = null;
        this.bytes = bytes;
        this.b_off = off;
        this.b_len = len;
        this.b_fixLeaf();
    }

    private void b_fixLeaf() {
        if (this.bytes[this.b_off + this.b_len - 1] == 43) {
            --this.b_len;
            this.setLeaf();
        } else if (this.getLevel() == this.spatialPrefixTree.getMaxLevels()) {
            this.setLeaf();
        }
    }

    public SpatialRelation getShapeRel() {
        return this.shapeRel;
    }

    public boolean isLeaf() {
        return this.shapeRel == SpatialRelation.WITHIN;
    }

    public void setLeaf() {
        assert (this.getLevel() != 0);
        this.shapeRel = SpatialRelation.WITHIN;
    }

    public String getTokenString() {
        if (this.token == null) {
            this.token = new String(this.bytes, this.b_off, this.b_len, SpatialPrefixTree.UTF8);
        }
        return this.token;
    }

    public byte[] getTokenBytes() {
        if (this.bytes != null) {
            if (this.b_off != 0 || this.b_len != this.bytes.length) {
                throw new IllegalStateException("Not supported if byte[] needs to be recreated.");
            }
        } else {
            this.bytes = this.token.getBytes(SpatialPrefixTree.UTF8);
            this.b_off = 0;
            this.b_len = this.bytes.length;
        }
        return this.bytes;
    }

    public int getLevel() {
        return this.token != null ? this.token.length() : this.b_len;
    }

    public Collection<Node> getSubCells(Shape shapeFilter) {
        if (shapeFilter instanceof Point) {
            return Collections.singleton(this.getSubCell((Point)shapeFilter));
        }
        Collection<Node> cells = this.getSubCells();
        if (shapeFilter == null) {
            return cells;
        }
        ArrayList<Node> copy = new ArrayList<Node>(cells.size());
        for (Node cell : cells) {
            SpatialRelation rel = cell.getShape().relate(shapeFilter);
            if (rel == SpatialRelation.DISJOINT) continue;
            cell.shapeRel = rel;
            copy.add(cell);
        }
        cells = copy;
        return cells;
    }

    public abstract Node getSubCell(Point var1);

    protected abstract Collection<Node> getSubCells();

    public abstract int getSubCellsSize();

    public abstract Shape getShape();

    public Point getCenter() {
        return this.getShape().getCenter();
    }

    @Override
    public int compareTo(Node o) {
        return this.getTokenString().compareTo(o.getTokenString());
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof Node && this.getTokenString().equals(((Node)obj).getTokenString());
    }

    public int hashCode() {
        return this.getTokenString().hashCode();
    }

    public String toString() {
        return this.getTokenString() + (this.isLeaf() ? Character.valueOf('+') : "");
    }
}

