/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import com.spatial4j.core.shape.Shape;
import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.spatial.prefix.AbstractPrefixTreeFilter;
import org.apache.lucene.spatial.prefix.tree.Cell;
import org.apache.lucene.spatial.prefix.tree.CellIterator;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;

public abstract class AbstractVisitingPrefixTreeFilter
extends AbstractPrefixTreeFilter {
    protected final int prefixGridScanLevel;

    public AbstractVisitingPrefixTreeFilter(Shape queryShape, String fieldName, SpatialPrefixTree grid, int detailLevel, int prefixGridScanLevel) {
        super(queryShape, fieldName, grid, detailLevel);
        this.prefixGridScanLevel = Math.max(0, Math.min(prefixGridScanLevel, grid.getMaxLevels() - 1));
        assert (detailLevel <= grid.getMaxLevels());
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    protected static class VNode {
        final VNode parent;
        Iterator<VNode> children;
        Cell cell;

        VNode(VNode parent) {
            this.parent = parent;
        }

        void reset(Cell cell) {
            assert (cell != null);
            this.cell = cell;
            assert (this.children == null);
        }
    }

    public abstract class VisitorTemplate
    extends AbstractPrefixTreeFilter.BaseTermsEnumTraverser {
        protected final boolean hasIndexedLeaves;
        private VNode curVNode;
        private BytesRef curVNodeTerm;
        private Cell scanCell;
        private BytesRef thisTerm;

        public VisitorTemplate(LeafReaderContext context, Bits acceptDocs, boolean hasIndexedLeaves) throws IOException {
            super(context, acceptDocs);
            this.curVNodeTerm = new BytesRef();
            this.hasIndexedLeaves = hasIndexedLeaves;
        }

        /*
         * Enabled aggressive block sorting
         */
        public DocIdSet getDocIdSet() throws IOException {
            assert (this.curVNode == null) : "Called more than once?";
            if (this.termsEnum == null) {
                return null;
            }
            this.thisTerm = this.termsEnum.next();
            if (this.thisTerm == null) {
                return null;
            }
            this.curVNode = new VNode(null);
            this.curVNode.reset(AbstractVisitingPrefixTreeFilter.this.grid.getWorldCell());
            this.start();
            this.addIntersectingChildren();
            while (this.thisTerm != null) {
                if (this.curVNode.children != null) {
                    assert (this.curVNode.children.hasNext());
                    this.preSiblings(this.curVNode);
                    this.curVNode = this.curVNode.children.next();
                } else {
                    VNode parentVNode = this.curVNode.parent;
                    while (true) {
                        if (parentVNode == null) {
                            return this.finish();
                        }
                        if (parentVNode.children.hasNext()) {
                            this.curVNode = parentVNode.children.next();
                            break;
                        }
                        this.postSiblings(parentVNode);
                        parentVNode.children = null;
                        parentVNode = parentVNode.parent;
                    }
                }
                this.curVNode.cell.getTokenBytesNoLeaf(this.curVNodeTerm);
                int compare = this.thisTerm.compareTo(this.curVNodeTerm);
                if (compare > 0) {
                    assert (!this.context.reader().terms(AbstractVisitingPrefixTreeFilter.this.fieldName).iterator(null).seekExact(this.curVNodeTerm)) : "should be absent";
                    continue;
                }
                if (compare < 0) {
                    TermsEnum.SeekStatus seekStatus = this.termsEnum.seekCeil(this.curVNodeTerm);
                    if (seekStatus == TermsEnum.SeekStatus.END) {
                        return this.finish();
                    }
                    this.thisTerm = this.termsEnum.term();
                    if (seekStatus == TermsEnum.SeekStatus.NOT_FOUND) continue;
                }
                boolean descend = this.visit(this.curVNode.cell);
                this.thisTerm = this.termsEnum.next();
                if (this.thisTerm == null) {
                    return this.finish();
                }
                if (!descend) continue;
                this.addIntersectingChildren();
            }
            return this.finish();
        }

        private void addIntersectingChildren() throws IOException {
            boolean scan;
            assert (this.thisTerm != null);
            Cell cell = this.curVNode.cell;
            if (cell.getLevel() >= AbstractVisitingPrefixTreeFilter.this.detailLevel) {
                throw new IllegalStateException("Spatial logic error");
            }
            if (this.hasIndexedLeaves && cell.getLevel() != 0) {
                this.scanCell = AbstractVisitingPrefixTreeFilter.this.grid.readCell(this.thisTerm, this.scanCell);
                assert (this.curVNode.cell.isPrefixOf(this.scanCell)) : "missing leaf or descendants";
                if (this.scanCell.getLevel() == cell.getLevel() && this.scanCell.isLeaf()) {
                    this.visitLeaf(this.scanCell);
                    this.thisTerm = this.termsEnum.next();
                    if (this.thisTerm == null) {
                        return;
                    }
                }
            }
            boolean bl = scan = cell.getLevel() >= AbstractVisitingPrefixTreeFilter.this.prefixGridScanLevel;
            if (!scan) {
                CellIterator subCellsIter = this.findSubCellsToVisit(cell);
                if (!subCellsIter.hasNext()) {
                    return;
                }
                this.curVNode.children = new VNodeCellIterator(subCellsIter, new VNode(this.curVNode));
            } else {
                this.scan(AbstractVisitingPrefixTreeFilter.this.detailLevel);
            }
        }

        protected CellIterator findSubCellsToVisit(Cell cell) {
            return cell.getNextLevelCells(AbstractVisitingPrefixTreeFilter.this.queryShape);
        }

        protected void scan(int scanDetailLevel) throws IOException {
            while (this.thisTerm != null) {
                this.scanCell = AbstractVisitingPrefixTreeFilter.this.grid.readCell(this.thisTerm, this.scanCell);
                if (!this.curVNode.cell.isPrefixOf(this.scanCell)) break;
                int termLevel = this.scanCell.getLevel();
                if (termLevel < scanDetailLevel) {
                    if (this.scanCell.isLeaf()) {
                        this.visitScanned(this.scanCell);
                    }
                } else if (termLevel == scanDetailLevel && !this.scanCell.isLeaf()) {
                    this.visitScanned(this.scanCell);
                }
                this.thisTerm = this.termsEnum.next();
            }
        }

        protected abstract void start() throws IOException;

        protected abstract DocIdSet finish() throws IOException;

        protected abstract boolean visit(Cell var1) throws IOException;

        protected abstract void visitLeaf(Cell var1) throws IOException;

        protected abstract void visitScanned(Cell var1) throws IOException;

        protected void preSiblings(VNode vNode) throws IOException {
        }

        protected void postSiblings(VNode vNode) throws IOException {
        }

        private class VNodeCellIterator
        implements Iterator<VNode> {
            final Iterator<Cell> cellIter;
            private final VNode vNode;

            VNodeCellIterator(Iterator<Cell> cellIter, VNode vNode) {
                this.cellIter = cellIter;
                this.vNode = vNode;
            }

            @Override
            public boolean hasNext() {
                return this.cellIter.hasNext();
            }

            @Override
            public VNode next() {
                assert (this.hasNext());
                this.vNode.reset(this.cellIter.next());
                return this.vNode;
            }

            @Override
            public void remove() {
            }
        }
    }
}

