/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;
import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.spatial.prefix.AbstractPrefixTreeFilter;
import org.apache.lucene.spatial.prefix.tree.Cell;
import org.apache.lucene.spatial.prefix.tree.CellIterator;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.SentinelIntSet;

public class ContainsPrefixTreeFilter
extends AbstractPrefixTreeFilter {
    protected final boolean multiOverlappingIndexedShapes;

    public ContainsPrefixTreeFilter(Shape queryShape, String fieldName, SpatialPrefixTree grid, int detailLevel, boolean multiOverlappingIndexedShapes) {
        super(queryShape, fieldName, grid, detailLevel);
        this.multiOverlappingIndexedShapes = multiOverlappingIndexedShapes;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        return this.multiOverlappingIndexedShapes == ((ContainsPrefixTreeFilter)((Object)o)).multiOverlappingIndexedShapes;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + (this.multiOverlappingIndexedShapes ? 1 : 0);
    }

    public DocIdSet getDocIdSet(LeafReaderContext context, Bits acceptDocs) throws IOException {
        return new ContainsVisitor(context, acceptDocs).visit(this.grid.getWorldCell(), acceptDocs);
    }

    private static class SmallDocSet
    extends DocIdSet
    implements Bits {
        private final SentinelIntSet intSet;
        private int maxInt = 0;

        public SmallDocSet(int size) {
            this.intSet = new SentinelIntSet(size, -1);
        }

        public boolean get(int index) {
            return this.intSet.exists(index);
        }

        public void set(int index) {
            this.intSet.put(index);
            if (index > this.maxInt) {
                this.maxInt = index;
            }
        }

        public int length() {
            return this.maxInt;
        }

        public int size() {
            return this.intSet.size();
        }

        public SmallDocSet union(SmallDocSet other) {
            SmallDocSet smaller;
            SmallDocSet bigger;
            if (other.intSet.size() > this.intSet.size()) {
                bigger = other;
                smaller = this;
            } else {
                bigger = this;
                smaller = other;
            }
            for (int v : smaller.intSet.keys) {
                if (v == smaller.intSet.emptyVal) continue;
                bigger.set(v);
            }
            return bigger;
        }

        public Bits bits() throws IOException {
            return this.size() > 4 ? this : null;
        }

        public DocIdSetIterator iterator() throws IOException {
            if (this.size() == 0) {
                return null;
            }
            int d = 0;
            final int[] docs = new int[this.intSet.size()];
            for (int v : this.intSet.keys) {
                if (v == this.intSet.emptyVal) continue;
                docs[d++] = v;
            }
            assert (d == this.intSet.size());
            final int size = d;
            Arrays.sort(docs, 0, size);
            return new DocIdSetIterator(){
                int idx = -1;

                public int docID() {
                    if (this.idx >= 0 && this.idx < size) {
                        return docs[this.idx];
                    }
                    return -1;
                }

                public int nextDoc() throws IOException {
                    if (++this.idx < size) {
                        return docs[this.idx];
                    }
                    return Integer.MAX_VALUE;
                }

                public int advance(int target) throws IOException {
                    return this.slowAdvance(target);
                }

                public long cost() {
                    return size;
                }
            };
        }

        public long ramBytesUsed() {
            return RamUsageEstimator.alignObjectSize((long)(RamUsageEstimator.NUM_BYTES_OBJECT_REF + 4)) + this.intSet.ramBytesUsed();
        }
    }

    private class ContainsVisitor
    extends AbstractPrefixTreeFilter.BaseTermsEnumTraverser {
        BytesRef termBytes;
        Cell nextCell;

        public ContainsVisitor(LeafReaderContext context, Bits acceptDocs) throws IOException {
            super(context, acceptDocs);
            this.termBytes = new BytesRef();
        }

        private SmallDocSet visit(Cell cell, Bits acceptContains) throws IOException {
            Cell subCell;
            if (this.termsEnum == null) {
                return null;
            }
            SmallDocSet leafDocs = this.getLeafDocs(cell, acceptContains);
            SmallDocSet combinedSubResults = null;
            Shape subCellsFilter = ContainsPrefixTreeFilter.this.queryShape;
            if (cell.getLevel() != 0 && (cell.getShapeRel() == null || cell.getShapeRel() == SpatialRelation.WITHIN)) {
                subCellsFilter = null;
                assert (cell.getShape().relate(ContainsPrefixTreeFilter.this.queryShape) == SpatialRelation.WITHIN);
            }
            CellIterator subCells = cell.getNextLevelCells(subCellsFilter);
            while (subCells.hasNext() && (combinedSubResults = !this.seekExact(subCell = subCells.next()) ? null : (subCell.getLevel() == ContainsPrefixTreeFilter.this.detailLevel ? this.getDocs(subCell, acceptContains) : (!ContainsPrefixTreeFilter.this.multiOverlappingIndexedShapes && subCell.getShapeRel() == SpatialRelation.WITHIN ? this.getLeafDocs(subCell, acceptContains) : this.visit(subCell, acceptContains)))) != null) {
                acceptContains = combinedSubResults;
            }
            if (combinedSubResults != null) {
                if (leafDocs == null) {
                    return combinedSubResults;
                }
                return leafDocs.union(combinedSubResults);
            }
            return leafDocs;
        }

        private boolean seekExact(Cell cell) throws IOException {
            assert (cell.getTokenBytesNoLeaf(null).compareTo(this.termBytes) > 0);
            if (this.termsEnum == null) {
                return false;
            }
            this.termBytes = cell.getTokenBytesNoLeaf(this.termBytes);
            assert (this.assertCloneTermBytes());
            return this.termsEnum.seekExact(this.termBytes);
        }

        private boolean assertCloneTermBytes() {
            this.termBytes = BytesRef.deepCopyOf((BytesRef)this.termBytes);
            return true;
        }

        private SmallDocSet getDocs(Cell cell, Bits acceptContains) throws IOException {
            assert (cell.getTokenBytesNoLeaf(null).equals((Object)this.termBytes));
            return this.collectDocs(acceptContains);
        }

        private SmallDocSet getLeafDocs(Cell cell, Bits acceptContains) throws IOException {
            assert (cell.getTokenBytesNoLeaf(null).equals((Object)this.termBytes));
            if (this.termsEnum == null) {
                return null;
            }
            BytesRef nextTerm = this.termsEnum.next();
            if (nextTerm == null) {
                this.termsEnum = null;
                return null;
            }
            this.nextCell = ContainsPrefixTreeFilter.this.grid.readCell(nextTerm, this.nextCell);
            assert (cell.isPrefixOf(this.nextCell));
            if (this.nextCell.getLevel() == cell.getLevel() && this.nextCell.isLeaf()) {
                return this.collectDocs(acceptContains);
            }
            return null;
        }

        private SmallDocSet collectDocs(Bits acceptContains) throws IOException {
            int docid;
            SmallDocSet set = null;
            this.docsEnum = this.termsEnum.docs(acceptContains, this.docsEnum, 0);
            while ((docid = this.docsEnum.nextDoc()) != Integer.MAX_VALUE) {
                if (set == null) {
                    int size = this.termsEnum.docFreq();
                    if (size <= 0) {
                        size = 16;
                    }
                    set = new SmallDocSet(size);
                }
                set.set(docid);
            }
            return set;
        }
    }
}

