/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.spatial4j;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;
import com.spatial4j.core.shape.impl.RectangleImpl;
import org.apache.lucene.spatial.spatial4j.geo3d.Bounds;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoArea;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoAreaFactory;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoPoint;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoShape;

public class Geo3dShape
implements Shape {
    public final SpatialContext ctx;
    public final GeoShape shape;
    private Rectangle boundingBox = null;
    public static final double RADIANS_PER_DEGREE = Math.PI / 180;
    public static final double DEGREES_PER_RADIAN = 57.29577951308232;
    protected final double ROUNDOFF_ADJUSTMENT = 0.01;

    public Geo3dShape(GeoShape shape, SpatialContext ctx) {
        if (!ctx.isGeo()) {
            throw new IllegalArgumentException("SpatialContext.isGeo() must be true");
        }
        this.ctx = ctx;
        this.shape = shape;
    }

    public SpatialRelation relate(Shape other) {
        if (other instanceof Rectangle) {
            return this.relate((Rectangle)other);
        }
        if (other instanceof Point) {
            return this.relate((Point)other);
        }
        throw new RuntimeException("Unimplemented shape relationship determination: " + other.getClass());
    }

    protected SpatialRelation relate(Rectangle r) {
        GeoArea geoArea = GeoAreaFactory.makeGeoArea(r.getMaxY() * (Math.PI / 180), r.getMinY() * (Math.PI / 180), r.getMinX() * (Math.PI / 180), r.getMaxX() * (Math.PI / 180));
        int relationship = geoArea.getRelationship(this.shape);
        if (relationship == 1) {
            return SpatialRelation.WITHIN;
        }
        if (relationship == 0) {
            return SpatialRelation.CONTAINS;
        }
        if (relationship == 2) {
            return SpatialRelation.INTERSECTS;
        }
        if (relationship == 3) {
            return SpatialRelation.DISJOINT;
        }
        throw new RuntimeException("Unknown relationship returned: " + relationship);
    }

    protected SpatialRelation relate(Point p) {
        GeoPoint point = new GeoPoint(p.getY() * (Math.PI / 180), p.getX() * (Math.PI / 180));
        if (this.shape.isWithin(point)) {
            return SpatialRelation.CONTAINS;
        }
        return SpatialRelation.DISJOINT;
    }

    public Rectangle getBoundingBox() {
        if (this.boundingBox == null) {
            double rightLon;
            double leftLon;
            Bounds bounds = this.shape.getBounds(null);
            if (bounds.checkNoLongitudeBound()) {
                leftLon = -180.0;
                rightLon = 180.0;
            } else {
                leftLon = bounds.getLeftLongitude() * 57.29577951308232;
                rightLon = bounds.getRightLongitude() * 57.29577951308232;
            }
            double minLat = bounds.checkNoBottomLatitudeBound() ? -90.0 : bounds.getMinLatitude() * 57.29577951308232;
            double maxLat = bounds.checkNoTopLatitudeBound() ? 90.0 : bounds.getMaxLatitude() * 57.29577951308232;
            this.boundingBox = new RectangleImpl(leftLon, rightLon, minLat, maxLat, this.ctx).getBuffered(0.01, this.ctx);
        }
        return this.boundingBox;
    }

    public boolean hasArea() {
        return true;
    }

    public double getArea(SpatialContext ctx) {
        throw new RuntimeException("Unimplemented");
    }

    public Point getCenter() {
        throw new RuntimeException("Unimplemented");
    }

    public Shape getBuffered(double distance, SpatialContext ctx) {
        return this;
    }

    public boolean isEmpty() {
        return false;
    }

    public String toString() {
        return "Geo3dShape{" + this.shape + '}';
    }

    public boolean equals(Object other) {
        if (!(other instanceof Geo3dShape)) {
            return false;
        }
        Geo3dShape tr = (Geo3dShape)other;
        return tr.shape.equals(this.shape);
    }

    public int hashCode() {
        return this.shape.hashCode();
    }
}

