/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.spatial4j.geo3d;

import org.apache.lucene.spatial.spatial4j.geo3d.Membership;

public class Vector {
    public static final double MINIMUM_RESOLUTION = 1.0E-12;
    public static final double MINIMUM_RESOLUTION_SQUARED = 1.0E-24;
    public static final double MINIMUM_RESOLUTION_CUBED = 1.0E-36;
    public final double x;
    public final double y;
    public final double z;

    public Vector(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector(Vector A, Vector B) {
        this(A.y * B.z - A.z * B.y, A.z * B.x - A.x * B.z, A.x * B.y - A.y * B.x);
    }

    public Vector normalize() {
        double denom = this.magnitude();
        if (denom < 1.0E-12) {
            return null;
        }
        double normFactor = 1.0 / denom;
        return new Vector(this.x * normFactor, this.y * normFactor, this.z * normFactor);
    }

    public double dotProduct(Vector v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public double dotProduct(double x, double y, double z) {
        return this.x * x + this.y * y + this.z * z;
    }

    public boolean isWithin(Membership[] bounds, Membership[] moreBounds) {
        for (Membership bound : bounds) {
            if (bound == null || bound.isWithin(this)) continue;
            return false;
        }
        for (Membership bound : moreBounds) {
            if (bound == null || bound.isWithin(this)) continue;
            return false;
        }
        return true;
    }

    public Vector translate(double xOffset, double yOffset, double zOffset) {
        return new Vector(this.x - xOffset, this.y - yOffset, this.z - zOffset);
    }

    public Vector rotateXY(double angle) {
        return this.rotateXY(Math.sin(angle), Math.cos(angle));
    }

    public Vector rotateXY(double sinAngle, double cosAngle) {
        return new Vector(this.x * cosAngle - this.y * sinAngle, this.x * sinAngle + this.y * cosAngle, this.z);
    }

    public Vector rotateXZ(double angle) {
        return this.rotateXZ(Math.sin(angle), Math.cos(angle));
    }

    public Vector rotateXZ(double sinAngle, double cosAngle) {
        return new Vector(this.x * cosAngle - this.z * sinAngle, this.y, this.x * sinAngle + this.z * cosAngle);
    }

    public Vector rotateZY(double angle) {
        return this.rotateZY(Math.sin(angle), Math.cos(angle));
    }

    public Vector rotateZY(double sinAngle, double cosAngle) {
        return new Vector(this.x, this.z * sinAngle + this.y * cosAngle, this.z * cosAngle - this.y * sinAngle);
    }

    public double linearDistanceSquared(Vector v) {
        double deltaX = this.x - v.x;
        double deltaY = this.y - v.y;
        double deltaZ = this.z - v.z;
        return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
    }

    public double linearDistanceSquared(double x, double y, double z) {
        double deltaX = this.x - x;
        double deltaY = this.y - y;
        double deltaZ = this.z - z;
        return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
    }

    public double linearDistance(Vector v) {
        return Math.sqrt(this.linearDistanceSquared(v));
    }

    public double linearDistance(double x, double y, double z) {
        return Math.sqrt(this.linearDistanceSquared(x, y, z));
    }

    public double normalDistanceSquared(Vector v) {
        double t = this.dotProduct(v);
        double deltaX = this.x * t - v.x;
        double deltaY = this.y * t - v.y;
        double deltaZ = this.z * t - v.z;
        return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
    }

    public double normalDistanceSquared(double x, double y, double z) {
        double t = this.dotProduct(x, y, z);
        double deltaX = this.x * t - x;
        double deltaY = this.y * t - y;
        double deltaZ = this.z * t - z;
        return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
    }

    public double normalDistance(Vector v) {
        return Math.sqrt(this.normalDistanceSquared(v));
    }

    public double normalDistance(double x, double y, double z) {
        return Math.sqrt(this.normalDistanceSquared(x, y, z));
    }

    public double magnitude() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Vector)) {
            return false;
        }
        Vector other = (Vector)o;
        return other.x == this.x && other.y == this.y && other.z == this.z;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.x);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.z);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "[X=" + this.x + ", Y=" + this.y + ", Z=" + this.z + "]";
    }
}

