/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.util;

import java.util.ArrayList;
import org.apache.lucene.spatial.util.GeoProjectionUtils;
import org.apache.lucene.spatial.util.GeoRect;
import org.apache.lucene.util.SloppyMath;

public final class GeoUtils {
    public static final double MIN_LON_INCL = -180.0;
    public static final double MAX_LON_INCL = 180.0;
    public static final double MIN_LAT_INCL = -90.0;
    public static final double MAX_LAT_INCL = 90.0;

    private GeoUtils() {
    }

    public static boolean isValidLat(double lat) {
        return !Double.isNaN(lat) && lat >= -90.0 && lat <= 90.0;
    }

    public static boolean isValidLon(double lon) {
        return !Double.isNaN(lon) && lon >= -180.0 && lon <= 180.0;
    }

    public static double normalizeLon(double lon_deg) {
        if (lon_deg >= -180.0 && lon_deg <= 180.0) {
            return lon_deg;
        }
        double off = (lon_deg + 180.0) % 360.0;
        if (off < 0.0) {
            return 180.0 + off;
        }
        if (off == 0.0 && lon_deg > 0.0) {
            return 180.0;
        }
        return -180.0 + off;
    }

    public static double normalizeLat(double lat_deg) {
        if (lat_deg >= -90.0 && lat_deg <= 90.0) {
            return lat_deg;
        }
        double off = Math.abs((lat_deg + 90.0) % 360.0);
        return (off <= 180.0 ? off : 360.0 - off) - 90.0;
    }

    public static ArrayList<double[]> circleToPoly(double lon, double lat, double radiusMeters) {
        int sides = 25;
        ArrayList<double[]> geometry = new ArrayList<double[]>();
        double[] lons = new double[25];
        double[] lats = new double[25];
        double[] pt = new double[2];
        int sidesLen = 24;
        for (int i = 0; i < 24; ++i) {
            double angle = i * 360 / 25;
            pt = GeoProjectionUtils.pointFromLonLatBearingGreatCircle(lon, lat, angle, radiusMeters, pt);
            lons[i] = pt[0];
            lats[i] = pt[1];
        }
        lons[24] = lons[0];
        lats[24] = lats[0];
        geometry.add(lons);
        geometry.add(lats);
        return geometry;
    }

    public static GeoRect circleToBBox(double centerLon, double centerLat, double radiusMeters) {
        double maxLon;
        double minLon;
        double radLat = Math.PI / 180 * centerLat;
        double radLon = Math.PI / 180 * centerLon;
        double radDistance = radiusMeters / 6378137.0;
        double minLat = radLat - radDistance;
        double maxLat = radLat + radDistance;
        if (minLat > -1.5707963267948966 && maxLat < 1.5707963267948966) {
            double deltaLon = SloppyMath.asin((double)(SloppyMath.sin((double)radDistance) / SloppyMath.cos((double)radLat)));
            minLon = radLon - deltaLon;
            if (minLon < -Math.PI) {
                minLon += Math.PI * 2;
            }
            if ((maxLon = radLon + deltaLon) > Math.PI) {
                maxLon -= Math.PI * 2;
            }
        } else {
            minLat = Math.max(minLat, -1.5707963267948966);
            maxLat = Math.min(maxLat, 1.5707963267948966);
            minLon = -Math.PI;
            maxLon = Math.PI;
        }
        return new GeoRect(57.29577951308232 * minLon, 57.29577951308232 * maxLon, 57.29577951308232 * minLat, 57.29577951308232 * maxLat);
    }

    public static GeoRect polyToBBox(double[] polyLons, double[] polyLats) {
        if (polyLons.length != polyLats.length) {
            throw new IllegalArgumentException("polyLons and polyLats must be equal length");
        }
        double minLon = Double.POSITIVE_INFINITY;
        double maxLon = Double.NEGATIVE_INFINITY;
        double minLat = Double.POSITIVE_INFINITY;
        double maxLat = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < polyLats.length; ++i) {
            if (!GeoUtils.isValidLon(polyLons[i])) {
                throw new IllegalArgumentException("invalid polyLons[" + i + "]=" + polyLons[i]);
            }
            if (!GeoUtils.isValidLat(polyLats[i])) {
                throw new IllegalArgumentException("invalid polyLats[" + i + "]=" + polyLats[i]);
            }
            minLon = Math.min(polyLons[i], minLon);
            maxLon = Math.max(polyLons[i], maxLon);
            minLat = Math.min(polyLats[i], minLat);
            maxLat = Math.max(polyLats[i], maxLat);
        }
        return new GeoRect(Math.max(minLon - 1.0E-6, -180.0), Math.min(maxLon + 1.0E-6, 180.0), Math.max(minLat - 1.0E-6, -90.0), Math.min(maxLat + 1.0E-6, 90.0));
    }
}

