/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.util;

import org.apache.lucene.spatial.util.GeoUtils;
import org.apache.lucene.util.SloppyMath;

public class GeoProjectionUtils {
    public static final double SEMIMAJOR_AXIS = 6378137.0;
    public static final double FLATTENING = 0.0033528106647474805;
    public static final double SEMIMINOR_AXIS = 6356752.314245179;
    public static final double ECCENTRICITY = StrictMath.sqrt(0.0066943799901413165);
    public static final double SEMIMAJOR_AXIS2 = 4.0680631590769E13;
    public static final double SEMIMINOR_AXIS2 = 4.0408299984661445E13;
    private static final double E2 = 0.006694379990141316;
    private static final double EP2 = 0.006739496742276434;
    public static final double MIN_LON_RADIANS = -Math.PI;
    public static final double MIN_LAT_RADIANS = -1.5707963267948966;
    public static final double MAX_LON_RADIANS = Math.PI;
    public static final double MAX_LAT_RADIANS = 1.5707963267948966;

    private GeoProjectionUtils() {
    }

    public static final double[] llaToECF(double lat, double lon, double alt, double[] ecf) {
        lon = Math.PI / 180 * lon;
        lat = Math.PI / 180 * lat;
        double sl = GeoUtils.sloppySin(lat);
        double s2 = sl * sl;
        double cl = SloppyMath.cos((double)lat);
        if (ecf == null) {
            ecf = new double[3];
        }
        if (lat < -1.5707963267948966 && lat > -1.5723671231216914) {
            lat = -1.5707963267948966;
        } else if (lat > 1.5707963267948966 && lat < 1.5723671231216914) {
            lat = 1.5707963267948966;
        }
        assert (lat >= -1.5707963267948966 || lat <= 1.5707963267948966);
        if (lon > Math.PI) {
            lon -= Math.PI * 2;
        }
        double rn = 6378137.0 / StrictMath.sqrt(1.0 - 0.006694379990141316 * s2);
        ecf[0] = (rn + alt) * cl * SloppyMath.cos((double)lon);
        ecf[1] = (rn + alt) * cl * GeoUtils.sloppySin(lon);
        ecf[2] = (rn * 0.9933056200098587 + alt) * sl;
        return ecf;
    }

    public static final double[] pointFromLonLatBearingGreatCircle(double lat, double lon, double bearing, double dist, double[] pt) {
        if (pt == null) {
            pt = new double[2];
        }
        lon *= Math.PI / 180;
        double cLat = SloppyMath.cos((double)(lat *= Math.PI / 180));
        double sLat = GeoUtils.sloppySin(lat);
        double sinDoR = GeoUtils.sloppySin(dist / 6378137.0);
        double cosDoR = SloppyMath.cos((double)(dist / 6378137.0));
        pt[1] = SloppyMath.asin((double)(sLat * cosDoR + cLat * sinDoR * SloppyMath.cos((double)(bearing *= Math.PI / 180))));
        pt[0] = 57.29577951308232 * (lon + Math.atan2(GeoUtils.sloppySin(bearing) * sinDoR * cLat, cosDoR - sLat * GeoUtils.sloppySin(pt[1])));
        pt[1] = pt[1] * 57.29577951308232;
        return pt;
    }

    public static double bearingGreatCircle(double lat1, double lon1, double lat2, double lon2) {
        double dLon = (lon2 - lon1) * (Math.PI / 180);
        double y = GeoUtils.sloppySin(dLon) * SloppyMath.cos((double)(lat2 *= Math.PI / 180));
        double x = SloppyMath.cos((double)(lat1 *= Math.PI / 180)) * GeoUtils.sloppySin(lat2) - GeoUtils.sloppySin(lat1) * SloppyMath.cos((double)lat2) * SloppyMath.cos((double)dLon);
        return Math.atan2(y, x) * 57.29577951308232;
    }
}

